/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Iterator;

/**
 *
 * @author Jagadish
 */
public class Table extends HTMLElement {
    
    private int border;
    private int cellSpacing;
    private String alignment;
    private float width;
    private boolean absoluteWidth;

    public static final String ALIGN_LEFT="LEFT";
    public static final String ALIGN_CENTER="CENTER";
    public static final String ALIGN_RIGHT="RIGHT";
    
    /** Creates a new instance of Table */
    public Table() {
        super("table");
    }
    
    /** Creates a new instance of Table */
    public Table( int border, int cellSpacing){
        this();
        addAttribute("border",String.valueOf(border));
        addAttribute("cellspacing",String.valueOf(cellSpacing));
        
    }
    
    /**
     *Sets the border attribute for the table
     *@param border in pixels
     */
    public void setBorder(int border){
        this.border = border;
        setAttribute("border",String.valueOf(border));
    }
    
    public void setCellSpacing(int cellSpacing){
        this.cellSpacing = cellSpacing;
        setAttribute("cellspacing", String.valueOf(cellSpacing));
    }
    
    public void setAlignment(String alignment){
        this.alignment = alignment;
        setAttribute("alignment",alignment );
    }
    
    public void setWidth(float width, boolean absolute){
        this.width = width;
        this.absoluteWidth = absolute;
        if(absolute){
            setAttribute("width",String.valueOf(width));
        }
        else{
            setAttribute("width",String.valueOf(width)+"%" );
        }
    }
    
    private void setAttribute(String property, String value){
        if(!(property==null || value==null)){
            List<Attribute> attributes= getAttributes(property);
            if(attributes.size()==0){
                addAttribute(property,value);
            }
            else{
                Attribute attribute = attributes.get(0);
                attribute.setValue(value);   
            }
        }
    }
    

    public int getBorder(){
        return border;
    }
    
    public int getCellSpacing(){
        return cellSpacing;
    }
    
    public String getAlignment(){
        return alignment;
    }
    
    public float getWidth(){
        return width;
    }
    
    public boolean isAbsoluteWidth(){
        return absoluteWidth;
    }
    
    public TR addRow(Iterator<String> values, boolean header, String cssClass) {
        TR row = new TR();
        while(values.hasNext()) {
            CSSElement tableData = null;
            if(header)
                tableData = new TH();
            else
                tableData = new TD();
            
            tableData.addText(values.next());
            setCSSClass(tableData, cssClass);
            row.add(tableData);
        }
        add(row);
        return row;
    }
    
    public TR addRow(ArrayList elements, String cssClass) {
        TR row = new TR();
        for(int i=0; i<elements.size();i++){
            TD tableData = new TD();
            tableData.add((Element)elements.get(i));
            setCSSClass(tableData, cssClass);
            row.add(tableData);
        }
        add(row);
        return row;
    }
    
    private void setCSSClass(CSSElement element, String cssClass) {
        if(cssClass != null){
            element.setCSSClass(cssClass);
        } 
    }
}
