/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.config.ConfigException;

/** 
 * The purpose of this class is to create localized ConfigException
 * objects conveniently.  The code is here instead of in ConfigException itself
 * to avoid passing in a StringManager reference everytime a ConfigException
 * is thrown -- and the concommitant increase in the number of constructors.
 * To use this class you create one instance for each calling class so that
 * the correct properties file is chosen automatically.
 *
 * Note that StringManager only uses the *package* name to locate the properties file.  
 * Also note that only this package can access this class.  Thus the StringManager
 * can be shared by all callers of this class.
 *
 * @author Byron Nevins
 */

class Localizer
{
	private Localizer()
	{
	}

	///////////////////////////////////////////////////////////////////////////

	static String getValue(ExceptionType type)
	{
		String key = type.getString();
		
		if(localStrings == null)
			return key;
		
		try
		{
			return localStrings.getStringWithDefault(key, key);
		}
		catch(Exception e)
		{
			return key;
		}
	}

	///////////////////////////////////////////////////////////////////////////

	static String getValue(ExceptionType type, String arg1of1)
	{
		return getValue(type, new Object[] { arg1of1 });
	}

	///////////////////////////////////////////////////////////////////////////

	static String getValue(ExceptionType type, int arg1of1)
	{
		return getValue(type, new Object[] { new Integer(arg1of1) });
	}

	///////////////////////////////////////////////////////////////////////////

	static String getValue(ExceptionType type, Object[] objs)
	{
		if(objs == null || objs.length <= 0)
			return getValue(type);

		String key = type.getString();
		
		if(localStrings == null)
			return key;
		
		try
		{
			return localStrings.getStringWithDefault(key, key, objs);
		}
		catch(Exception e)
		{
			return key;
		}
	}

	///////////////////////////////////////////////////////////////////////////

	private static StringManager localStrings;
	
	static
	{
		try
		{
			localStrings = StringManager.getManager(Localizer.class.getPackage().getName());
		}
		catch(Exception e)
		{
			//StringManager has already logged the problem...
			localStrings = null;
		}
	}
}
