/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.naming;

import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.*;
import javax.naming.spi.InitialContextFactory;
import com.sun.enterprise.util.ORBManager;
import com.sun.appserv.naming.S1ASCtxFactory;

/**
 * Implements the JNDI SPI InitialContextFactory interface used to create
 * the InitialContext objects. It creates an instance of the serial context.
 */

public class SerialInitContextFactory implements InitialContextFactory {


    private Hashtable defaultEnv;

    private S1ASCtxFactory s1asCtxFactory;

    private String LBPOLICY = 
                 System.getProperty(S1ASCtxFactory.LOAD_BALANCING_PROPERTY);

    private String ENDPOINTS = 
                 System.getProperty(S1ASCtxFactory.IIOP_ENDPOINTS_PROPERTY);
    
    private static boolean _initializeOrbManager = true;

    static {
        // setting ORB class and ORB singleton to SE values
        //setting RMI-IIOP delegates to EE values
        com.sun.enterprise.util.ORBManager.setORBSystemProperties();
    }

    /**
     * Set to false if you do not want the OrbManager to be initialized. 
     * This is necessary in the NodeAgent since OrbManager initialization causes
     * the NSS certificate database to be opended (and loaded) in which case
     * it cannot be synchronized on Windows platforms (file in use).
     */
    public static void setInitializeOrbManager(boolean init) {
        _initializeOrbManager = init;
    }
    
    /** 
     * Default constructor. Creates an ORB if one is not already created.
     */
    public SerialInitContextFactory() {
     
        if ((LBPOLICY != null &&
	     !LBPOLICY.equals("")) ||
	    (ENDPOINTS != null &&
	     !ENDPOINTS.equals(""))) {
	    s1asCtxFactory = new S1ASCtxFactory();
	} else {
	    // create a default env
	    defaultEnv = new Hashtable();

	    // Client side : removing the initialization of the ORB 
	    // from the constructor since
	    // we need to propagate the host:port values that are 
	    // set in the App client to ORB.init()	    
	    /*    if (_initializeOrbManager) {
	        ORBManager.init(null, null);
		defaultEnv.put("java.naming.corba.orb", ORBManager.getORB());
		}*/
	}
    }

    // Removing this constructor since it never gets called in the 
    // in the JNDI code path
    // a call to new InitialContext(env) creates an instance of 
    // this class via the SerialInitContextFactory.class.newInstance()
    // which will call the nullary constructor

    /*  public SerialInitContextFactory(Hashtable env) {

	if ((LBPOLICY != null &&
	     !LBPOLICY.equals("")) ||
	    (ENDPOINTS != null &&
	     !ENDPOINTS.equals("")) ||
	    env.get(S1ASCtxFactory.LOAD_BALANCING_PROPERTY) != null ||
	    env.get(S1ASCtxFactory.IIOP_ENDPOINTS_PROPERTY) != null) {
	    s1asCtxFactory = new S1ASCtxFactory(env);
	} else {
	    defaultEnv = env;
	    if (_initializeOrbManager) {
	        ORBManager.init(null, (Properties)env);
		defaultEnv.put("java.naming.corba.orb", ORBManager.getORB());
		System.out.println("SHEETAL : port# " + ORBManager.getORBInitialPort());
	    }
	}
    }
*/
    /**
     * Create the InitialContext object.
     */
    public Context getInitialContext(Hashtable env) throws NamingException {
        
	if (_initializeOrbManager && 
	    (env == null || 
	     (env != null && env.get("java.naming.corba.orb") == null))) {

	    //javax.naming.InitialContext passes its own local Hashtable 
	    //variable, so can't cast it to Properties.
	  
	    Properties props = new Properties();
	    if (env != null) {
	        if (env.get("org.omg.CORBA.ORBInitialHost") != null &&
		    env.get("org.omg.CORBA.ORBInitialPort") != null) {
		    props.put("org.omg.CORBA.ORBInitialHost", 
			      (String) env.get("org.omg.CORBA.ORBInitialHost"));
		    props.put("org.omg.CORBA.ORBInitialPort", 
			      (String) env.get("org.omg.CORBA.ORBInitialPort"));
		}			
	    }
	    org.omg.CORBA.ORB orb = ORBManager.getORB(props) ;
	    if (defaultEnv != null)
		defaultEnv.put("java.naming.corba.orb", orb ) ; 
	    if (env != null)
		env.put("java.naming.corba.orb", orb );
	}
	
	if (SerialContext.getSticky() != null) {
	    Context ctx = SerialContext.getStickyContext();	
	    return ctx;
	}

	if (s1asCtxFactory != null) {
	    return (s1asCtxFactory.getInitialContext(env));
	}
        
	if (env != null) {	    	    
            return new SerialContext(env);
        } else {
            return new SerialContext(defaultEnv);
        }
    }
}
