/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.*;
import java.io.Serializable;

/**
 * Base class for common J2EEResource implementation.
 *
 * @author
 */
public abstract class J2EEResourceBase implements J2EEResource, Serializable {

    String name_;
    Map    properties_;
    // START OF IASRI #4626188
    boolean enabled_;
    String description_;
    // END OF IASRI #4626188

    public J2EEResourceBase(String name) {
        name_ = name;
        properties_ = new HashMap();
    }

    public String getName() {
        return name_;
    }

    // START OF IASRI #4626188
    public void setEnabled(boolean value) {
        enabled_ = value;
    }
    
    public boolean isEnabled() {
        return enabled_;
    }
    
    public void setDescription(String value) {
        description_ = value;
    }
    
    public String getDescription() {
        return description_;
    }
    // END OF IASRI #4626188
    
    public abstract int getType();

    public Set getProperties() {
        Set shallowCopy = new HashSet();
        Collection collection = properties_.values();
        for(Iterator iter = collection.iterator(); iter.hasNext();) {
            ResourceProperty next = (ResourceProperty) iter.next();
            shallowCopy.add(next);
        }
        return shallowCopy;
    }
    
    public void addProperty(ResourceProperty property) {
        properties_.put(property.getName(), property);
    }

    public boolean removeProperty(ResourceProperty property) {
        Object removedObj = properties_.remove(property.getName());
        return (removedObj != null);
    }

    public ResourceProperty getProperty(String propertyName) {
        return (ResourceProperty) properties_.get(propertyName);
    }

    public J2EEResource makeClone(String name) {
        J2EEResource clone = doClone(name);
        Set entrySet = properties_.entrySet();
        for(Iterator iter = entrySet.iterator(); iter.hasNext();) {
            Map.Entry next = (Map.Entry) iter.next();
            ResourceProperty nextProp = (ResourceProperty) next.getValue();
            ResourceProperty propClone =
                new ResourcePropertyImpl((String) next.getKey());
            propClone.setValue(next.getValue());
                                         
            clone.addProperty(propClone);
        }
        // START OF IASRI #4626188
        clone.setEnabled(isEnabled());
        clone.setDescription(getDescription());
        // END OF IASRI #4626188             
        return clone;
    }

    protected String getPropsString() {
        StringBuffer propsBuffer = new StringBuffer();
        Set props = getProperties();
        if( !props.isEmpty() ) {
            for(Iterator iter = props.iterator(); iter.hasNext(); ) {
                if( propsBuffer.length() == 0 ) {
                    propsBuffer.append("[ ");
                } else {
                    propsBuffer.append(" , ");
                }
                ResourceProperty next = (ResourceProperty) iter.next();
                propsBuffer.append(next.getName() + "=" + next.getValue());
            }
            propsBuffer.append(" ]");
        }
        return propsBuffer.toString();
    }

    protected abstract J2EEResource doClone(String name);
}
