/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.util.Hashtable;
import java.util.Enumeration;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;
// IASRI 4660742 START
import java.util.logging.*;
import com.sun.logging.*;
// IASRI 4660742 END

/**
 * @author Harish Prabandham
 */
public class RepositoryInitContextFactory implements InitialContextFactory {
// IASRI 4660742 START
    private static Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.ROOT_LOGGER);
        }
// IASRI 4660742 END

    public Context getInitialContext(Hashtable env) {
        return new RepositoryContext(env);
    }

	public static void print(Hashtable env)
	{
// IASRI 4660742		System.out.println("RepositoryContextFactory[");
// START OF IASRI 4660742
		_logger.log(Level.FINE,"RepositoryContextFactory[");
// END OF IASRI 4660742
		for(Enumeration e = env.keys(); e.hasMoreElements(); )
		{
			String key = (String) e.nextElement();
			Object value = env.get(key);

// IASRI 4660742			System.out.println("(" + key + " , " + value + ")" );
// START OF IASRI 4660742
			_logger.log(Level.FINE,"(" + key + " , " + value + ")");
// END OF IASRI 4660742
		}
// IASRI 4660742		System.out.println("]");
// START OF IASRI 4660742
			_logger.log(Level.FINE,"]");
// END OF IASRI 4660742
	}
}
