
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;

import java.util.*;
import java.util.logging.*;

import javax.transaction.*;
import javax.transaction.xa.*;

import com.sun.logging.*;
import com.sun.enterprise.*;
import com.sun.enterprise.log.Log;

/**
 * Resource Manager for a resource request from a component
 * that is not to be associated with a transaction.
 *
 * @author Aditya Gore
 */
public class NoTxResourceManagerImpl implements ResourceManager {
    
    
    static Logger _logger = null;
    static {
        _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    }
    
    /**
     * Returns null since this connection is outside any tx context
     *
     * @exception <code>PoolingException<code>
     */
    public Transaction getTransaction() throws PoolingException{
        return null;
    }
    
    /**
     * Returns the component invoking resource request.
     *
     * @return Handle to the component
     */
    public Object getComponent(){
	return null;
    }
    
    /**
     * Enlist the <code>ResourceHandle</code> in the transaction
     * This implementation of the method is expected to be a no-op
     *
     * @param h	<code>ResourceHandle</code> object
     * @exception <code>PoolingException</code>
     */
    public void enlistResource(ResourceHandle h) throws PoolingException{
        if (_logger.isLoggable( Level.FINE ) ) {
	    _logger.fine( "NoTxResourceManagerImpl :: enlistResource called");
	}
    }
    
    /**
     * Register the <code>ResourceHandle</code> in the transaction
     * This implementation of the method is expected to be a no-op
     *
     *
     * @param h	<code>ResourceHandle</code> object
     * @exception <code>PoolingException</code>
     */
    public void registerResource(ResourceHandle handle)
            throws PoolingException 
    {
        if (_logger.isLoggable( Level.FINE ) ) {
	    _logger.fine( "NoTxResourceManagerImpl :: registerResource called");
	}
    }
    
    /**
     * Get's the component's transaction and marks it for rolling back.
     * This implementation of the method is expected to be a no-op
     *
     */
    public void rollBackTransaction() {
	if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("rollBackTransaction called in NoTxResourceManagerImpl");
	}
    }
    
    /**
     * delist the <code>ResourceHandle</code> from the transaction
     * This implementation of the method is expected to be a no-op
     *
     *
     * @param h	<code>ResourceHandle</code> object
     * @param xaresFlag flag indicating transaction success. This can
     *        be XAResource.TMSUCCESS or XAResource.TMFAIL
     * @exception <code>PoolingException</code>
     */
    public void delistResource(ResourceHandle resource, int xaresFlag) {
        if (_logger.isLoggable( Level.FINE ) ) {
	    _logger.fine( "NoTxResourceManagerImpl :: delistResource called");
	}
    }
    
    /**
     * Unregister the <code>ResourceHandle</code> from the transaction
     * This implementation of the method is expected to be a no-op
     *
     *
     * @param h	<code>ResourceHandle</code> object
     * @param xaresFlag flag indicating transaction success. This can
     *        be XAResource.TMSUCCESS or XAResource.TMFAIL
     * @exception <code>PoolingException</code>
     */
    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        if (_logger.isLoggable( Level.FINE ) ) {
	    _logger.fine( "NoTxResourceManagerImpl :: unregisterResource called");
	}
    }
}
