/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;


import javax.transaction.Transaction;
import com.sun.enterprise.connectors.ConnectorConnectionPool;

/**
 * @author Tony Ng
 */
public interface ResourcePool {

    // start IASRI 4649256
    // Modify getResource() to throw PoolingException
    public ResourceHandle getResource(ResourceSpec spec,
                                      ResourceAllocator alloc,
                                      Transaction tran) throws PoolingException;
    // end IASRI 4649256

    public void resourceClosed(ResourceHandle resource);

    public void resourceErrorOccurred(ResourceHandle resource);

    public void addResource(ResourceSpec spec,
                            ResourceHandle resource);

    public void resourceEnlisted(Transaction tran, ResourceHandle resource);

    public void transactionCompleted(Transaction tran, int status);

    public void resizePool(boolean forced);

    // forcefully destroy all connections in the pool even if
    // connections have transactions in progress
    public void emptyPool();


    //reconfig the pool's properties
    public void reconfigPoolProperties( ConnectorConnectionPool ccp )
            throws PoolingException;

    //toggle monitoring
    public void disableMonitoring();
    public void setMonitoringEnabledHigh();
    public void setMonitoringEnabledLow();
    public boolean isMonitoringEnabled();

    //cancel the resizer task in the pool
    public void cancelResizerTask();

    public void switchOnMatching();

    public String getPoolName();

    public void emptyFreeConnectionsInPool();

    //accessors for self mgmt
    /** 
     * Gets the max-pool-size attribute of this pool. Envisaged to be
     * used by the Self management framework to query the pool size
     * attribute for tweaking it using the setMaxPoolSize method
     *
     * @return max-pool-size value for this pool
     * @see setMaxPoolSize
     */
    public int getMaxPoolSize();
    
    /** 
     * Gets the steady-pool-size attribute of this pool. Envisaged to be
     * used by the Self management framework to query the pool size
     * attribute for tweaking it using the setSteadyPoolSize method
     *
     * @return steady-pool-size value for this pool
     * @see setSteadyPoolSize
     */
    public int getSteadyPoolSize();

    //mutators for self mgmt
    /**
     * Sets the max-pool-size value for this pool. This attribute is
     * expected to be set by the self-management framework for an optimum
     * max-pool-size. The corresponding accessor gets this value.
     *
     * @param size - The new max-pool-size value
     * @see getMaxPoolSize
     */
    public void setMaxPoolSize( int size );
    
    /**
     * Sets the steady-pool-size value for this pool. This attribute is
     * expected to be set by the self-management framework for an optimum
     * steady-pool-size. The corresponding accessor gets this value.
     *
     * @param size - The new steady-pool-size value
     * @see getSteadyPoolSize
     */
    public void setSteadyPoolSize( int size );

    /**
     * Sets/Resets the flag indicating if this pool is self managed.
     * This method would be typically called by the self management
     * framework to indicate to the world (and this pool) that this
     * pool is self managed. Its very important that the self mgmt
     * framework properly sets this flag to control the dynamic reconfig
     * behavior of this pool. If this flag is set to true, all dynamic
     * reconfigs affecting the max/steady pool size of this pool will
     * be ignored.
     *
     * @param selfManaged - true to switch on self management, false otherwise
     */
    public void setSelfManaged( boolean selfManaged );
}


