/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.ssl;

import java.util.HashSet;
import java.util.Iterator;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;

/**
 * This class combines an array of X509TrustManagers into one.
 * @author Shing Wai Chan
 **/
public class UnifiedX509TrustManager implements X509TrustManager {
    private X509TrustManager[] mgrs = null;
    private X509Certificate[] issuers = {};

    public UnifiedX509TrustManager(X509TrustManager[] mgrs) {
        if (mgrs == null) {
            throw new IllegalArgumentException("Null array of X509TrustManagers");
        }
        this.mgrs = mgrs;

        HashSet tset = new HashSet(); //for uniqueness
        for (int i = 0; i < mgrs.length; i++) {
            X509Certificate[] tcerts = mgrs[i].getAcceptedIssuers();
            if (tcerts != null && tcerts.length > 0) {
                for (int j = 0; j < tcerts.length; j++) {
                    tset.add(tcerts[j]);
                }
            }
        }
        issuers = new X509Certificate[tset.size()];
        Iterator iter = tset.iterator();
        for (int i = 0; iter.hasNext(); i++) {
            issuers[i] = (X509Certificate)iter.next();
        }
    }

    // ---------- implements X509TrustManager -----------
    public void checkClientTrusted(X509Certificate[] chain, String authType)
            throws CertificateException {
        CertificateException cex = null;
        for (int i = 0; i < mgrs.length; i++) {
            try {
                cex = null; //reset exception status
                mgrs[i].checkClientTrusted(chain, authType);
                break;
            } catch(CertificateException ex) {
                cex = ex;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType)
            throws CertificateException {
        CertificateException cex = null;
        for (int i = 0; i < mgrs.length; i++) {
            try {
                cex = null; //reset exception status
                mgrs[i].checkServerTrusted(chain, authType);
                break;
            } catch(CertificateException ex) {
                cex = ex;
            }
        }
        if (cex != null) {
            throw cex;
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return issuers;
    }
}
