/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.logging;

import java.util.Timer;

public class LogRotationTimer {
    private Timer rotationTimer;

    private LogRotationTimerTask rotationTimerTask;

    private static LogRotationTimer instance = new LogRotationTimer( );

    private LogRotationTimer( ) {
        rotationTimer = new Timer( );
    }

    public static LogRotationTimer getInstance( ) {
        return instance;
    }

    public void startTimer( LogRotationTimerTask timerTask ) {
        rotationTimerTask = timerTask;
        rotationTimer.schedule( rotationTimerTask, 
            timerTask.getRotationTimerValue( ) );
    }

    public void stopTimer( ) {
        rotationTimer.cancel( );
    }

    public void restartTimer( ) {
        // We will restart the timer only if the timerTask is set which
        // means user has set a value for LogRotation based on Time
        if( rotationTimerTask != null ) {
            rotationTimerTask.cancel( );
            rotationTimerTask = new LogRotationTimerTask( 
                // This is wierd, We need to have a fresh TimerTask object
                // to reschedule the work. 
                rotationTimerTask.getRotationTimerValueInMinutes( ) );
            rotationTimer.schedule( rotationTimerTask, 
                rotationTimerTask.getRotationTimerValue( ) );
        } 
    } 
}
