/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ondemand.entry;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.server.ondemand.OnDemandServer;
import javax.management.ObjectName;

/**
 * Helper class that can be used by entrypoints to generate
 * entry events.
 * 
 * @author Binod PG
 */
public class ServerEntryHelper {

    public static void generateJndiEntryContext(String jndiName) {
        sendEvent (new EntryContext(jndiName, EntryPoint.JNDI));
    }

    public static void generatePortEntryContext(Integer port) {
        sendEvent (new EntryContext(port, EntryPoint.PORT));
    }

    public static void generateAppLoaderEntryContext(Descriptor desc) {
        sendEvent (new EntryContext(desc, EntryPoint.APPLOADER));
    }

    public static void generateStartUpEntryContext(Boolean obj) {
        sendEvent (new EntryContext(obj, EntryPoint.STARTUP));
    }

    public static void generateMbeanEntryContext(ObjectName name) {
        sendEvent (new EntryContext(name, EntryPoint.MBEAN));
    }

    // Send the event to the listener registered in ondemand server.
    public static void sendEvent(EntryContext context) {
        ServerEntryListener listener = OnDemandServer.getServerEntryListener();
        if (listener != null) {
            listener.notifyEntry(context);
        }
    }

    public static boolean isNotifiedByPortEntryContext(Integer port) {
        return isNotified(new EntryContext(port, EntryPoint.PORT));
    }

    public static boolean isNotified(EntryContext context) {
        ServerEntryListener listener = OnDemandServer.getServerEntryListener();
        return listener.isNotified(context);
    }
    
}
