/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.deploy;

import org.apache.catalina.deploy.SecurityCollection;
import com.sun.enterprise.deployment.web.WebResourceCollection;

import org.apache.catalina.util.RequestUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

/**
 * Decorator of class <code>org.apache.catalina.deploy.SecurityCollection</code>
 *
 * @author Jean-Francois Arcand
 */

public class SecurityCollectionDecorator extends SecurityCollection {

   private WebResourceCollection decoree;
   
   public SecurityCollectionDecorator(WebResourceCollection decoree){
        this.decoree = decoree;
        
        Enumeration enumeration = decoree.getUrlPatterns();
        while(enumeration.hasMoreElements()){
            addPattern( (String)enumeration.nextElement() );
        }
        
        enumeration = decoree.getHttpMethods();
        while(enumeration.hasMoreElements()){
            addMethod( (String)enumeration.nextElement() );
        }                
   }


    /**
     * Return the description of this web resource collection.
     */
    public String getDescription() {
        return decoree.getDescription();
    }



    /**
     * Return the name of this web resource collection.
     */
    public String getName() {
        return decoree.getName();
    }


    // --------------------------------------------------------- Public Methods

}