/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.beans;

import java.util.*;
import java.text.*;

/**
 * Customers Datastore.
 *
 * @author Pierre Delisle
 * @version $Revision: 1.2 $ $Date: 2005/12/08 01:20:37 $
 */

public class Customers {
    
    //*********************************************************************
    // Instance variables
    
    private static Vector customers = new Vector();
    private static int nextSeqNo = 0;
    
    //*********************************************************************
    // Datastore operations
    
    public static void create(
    String lastName,
    String firstName,
    String birthDate,
    String line1,
    String line2,
    String city,
    String state,
    String zip,
    String country) {
        create(lastName, firstName, birthDate, line1, line2, city, state, zip,
        country, null, null);
    }
    
    /**
     *  Create new customer
     */
    public static void create(
    String lastName,
    String firstName,
    String birthDate,
    String line1,
    String line2,
    String city,
    String state,
    String zip,
    String country,
    String phoneHome,
    String phoneCell) {
        Customer customer =
        new Customer(++nextSeqNo, lastName, firstName,
        genDate(birthDate), genAddress(line1, line2, city, state, zip, country),
        phoneHome, phoneCell);
        customers.add(customer);
    }
    
    /**
     * Find all customers
     */
    public static Collection findAll() {
        return customers;
    }
    
    //*********************************************************************
    // Utility methods
    
    private static Date genDate(String dateString) {
        DateFormat df = new SimpleDateFormat("M/d/y");
        Date date;
        try {
            date = df.parse(dateString);
        } catch (Exception ex) {
            date = null;
        }
        return date;
    }
    
    private static Address genAddress(String line1, String line2, String city,
    String state, String zip, String country) {
        return new Address(line1, line2, city, state, zip, country);
    }
}
