/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.taglib;

import java.lang.reflect.Array;

import javax.servlet.jsp.JspTagException;

/**
 * <p>Exmaples taglib Functions</p>
 * 
 * @author Pierre Delisle
 */

public class Functions {

    /**
     * Display the collection types supported by c:forEach.
     */
    public static String display(Object obj) throws JspTagException {
        if (obj == null) return "";         
        if (obj instanceof String) return obj.toString();
        /*
        if (obj instanceof Collection) {
            return "FIXME";
        }
        if (obj instanceof Map) {
            return "FIXME";
        }        
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                iter.next();
            }
            return "FIXME";
        }            
        if (obj instanceof Enumeration) {
            Enumeration enum_ = (Enumeration)obj;
            while (enum_.hasMoreElements()) {
                enum_.nextElement();
            }
            return "FIXME";
        }
        */
        try {
            StringBuffer buf = new StringBuffer();
            int count = Array.getLength(obj);
            for (int i=0; i<count; i++) {
                buf.append(Array.get(obj, i).toString());
                if (i<count-1) buf.append("<font color='red'> &#149; </font>");
            }
            return buf.toString();
        } catch (IllegalArgumentException ex) {}
        throw new JspTagException("Bad Item");        
    }      
}
