/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * VerifierUtils.java
 *
 * Created on September 9, 2002, 12:08 PM
 */

package com.sun.enterprise.tools.verifier;

import javax.enterprise.deploy.shared.ModuleType;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.JarArchiveFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.util.shared.ArchivistUtils;

/**
 * @author dochez
 */
public class VerifierUtils {

    public static void copyArchiveToDir(File source, File dest)
            throws IOException {
        AbstractArchive in = null;
        try {
            in =
                    (new JarArchiveFactory()).openArchive(
                            source.getAbsolutePath());
            copyArchiveToDir(in, dest);
        } finally {
            if (in != null)
                in.close();
        }
    }

    public static void copyArchiveToDir(AbstractArchive source, File dest)
            throws IOException {
        for (Enumeration elements = source.entries();
             elements.hasMoreElements();) {
            String elementName = (String) elements.nextElement();
            InputStream is = source.getEntry(elementName);
            OutputStream fos = null;
            try {
                if (elementName.indexOf('/') != -1) {
                    String directory = elementName.substring(0,
                            elementName.lastIndexOf('/'));
                    File dir = new File(dest, directory);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                }
                File elementFile = new File(dest, elementName);
                fos = new BufferedOutputStream(
                        new FileOutputStream(elementFile));
                ArchivistUtils.copy(is, fos);
            } finally {
                try {
                    if(is != null)
                        is.close();
                    if(fos != null)
                        fos.close();
                } catch (Exception e) {}
            }
        }
    }

}
