/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl;
import com.sun.enterprise.deployment.Descriptor;

import java.util.Collection;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ClassContainsNativeMethod
        extends VerifierTest implements VerifierCheck {
    public Result check(Descriptor descriptor) {
        ComponentNameConstructor compName =
                getVerifierContext().getComponentNameConstructor();
        Result result = getInitializedResult();
        result.setStatus(Result.PASSED);
        ClosureCompilerImpl cc = ClosureCompilerImpl.class.cast(
                getVerifierContext().getClosureCompiler());
        Collection<String> nativeMethods = cc.getNativeMethods();
        if(!nativeMethods.isEmpty()) {
            addWarningDetails(result, compName);
            result.warning(smh.getLocalString(getClass().getName() + ".warning",
                    "Supplied below is the list of method names " +
                    "(in the format <package.classname>.<methodName>) " +
                    "that are defined as native methods and used by the application:\n"));
            for(String m : nativeMethods) {
                result.warning("\n\t" + m);
            }
            result.warning(smh.getLocalString(getClass().getName() + ".suggestion",
                    "Please make sure that they are implemented on all operating systems."));
        }
        return result;
    }
}
