/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.*;
import java.io.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.util.FileClassLoader;


/** 
 * Exception-type element contains a fully qualified class name of a Java 
 * exception type.
 */
public class ExceptionType extends WebTest implements WebCheck { 

    
    /** 
     * Exception-type element contains a fully qualified class name of a Java 
     * exception type.
     *
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = loadWarFile(descriptor);
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor.getErrorPageDescriptors().hasMoreElements()) {
	    boolean oneFailed = false;
	    int oneExceptionType = 0;
	    int oneNA = 0;
	    boolean foundIt = false;
	    // get the errorpage's in this .war
	    for (Enumeration e = descriptor.getErrorPageDescriptors() ; e.hasMoreElements() ;) {
		foundIt = false;
                oneExceptionType++;
		ErrorPageDescriptorImpl errorpage = (ErrorPageDescriptorImpl) e.nextElement();
                if (errorpage.getErrorCode() == 0) {
		    String exceptionType = errorpage.getExceptionType();
		    if ((exceptionType != null) && (exceptionType.length() > 0)) {
		        boolean isValidExceptionType = false;
			try {
			    Class c = loadClass(result, exceptionType);
			    if (isSubclassOf(c, "java.lang.Exception")) {
			      isValidExceptionType = true;
			    }
			} catch (Exception ex) {
			  // should already be set
			  isValidExceptionType = false;
			}
			
			if (isValidExceptionType) {
			    foundIt = true;
			} else {
			    foundIt = false;
			}
   
			if (foundIt) {
			    result.addGoodDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

			    result.addGoodDetails(smh.getLocalString
						  (getClass().getName() + ".passed",
						   "Exception type [ {0} ] contains a fully qualified class name of a Java exception type within web application [ {1} ]",
						   new Object[] {exceptionType, descriptor.getName()}));
			} else {
			    if (!oneFailed) {
				oneFailed = true;
			    }
			    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

			    result.addErrorDetails(smh.getLocalString
						   (getClass().getName() + ".failed",
						    "Error: Exception type [ {0} ] does not contain a fully qualified class name of a Java exception type within web application [ {1} ]",
						    new Object[] {exceptionType, descriptor.getName()}));
			}
		    } else {
			if (!oneFailed) {
			    oneFailed = true;
			}
			Integer errorCode = new Integer( errorpage.getErrorCode() );
			result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

			result.addErrorDetails(smh.getLocalString
					       (getClass().getName() + ".failed",
						"Error: Exception type [ {0} ] does not contain a fully qualified class name of a Java exception type within web application [ {1} ]",
						new Object[] {errorCode.toString(), descriptor.getName()}));
		        oneNA++;
		    }  
		} else {
		    // maybe Exception is null 'cause we are using ErrorCode
		    // if that is the case, then test is N/A, 
		    Integer errorCode = new Integer( errorpage.getErrorCode() );
		    result.addNaDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

		    result.addNaDetails(smh.getLocalString
					(getClass().getName() + ".notApplicable1",
					 "Exception type is null, using error-code [ {0} ] instead within web application [ {1} ]",
					 new Object[] {errorCode.toString(), descriptor.getName()}));
		    oneNA++;
		}  
	    }
	    if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else if (oneNA == oneExceptionType) {
		result.setStatus(Result.NOT_APPLICABLE);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {
	    result.addNaDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));

	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no exception-type elements within the web archive [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}

	return result;
    }
}
