/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.TagLibTest;
import com.sun.enterprise.tools.verifier.web.FunctionDescriptor;

/**
 * The specified method, in function-signature element, must be a public static
 * method in the specified class, and must be specified using a fully-qualified
 * return type followed by the method name, followed by the fully-qualified
 * argument types in parenthesis, separated by commas.
 * 
 * @author Sudipto Ghosh
 */
public class TaglibFunctionMethodTest extends TagLibTest implements WebCheck {

    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName =
                getVerifierContext().getComponentNameConstructor();
        Result result = getInitializedResult();
        Context context = getVerifierContext();
        TagLibDescriptor tlds[] = context.getTagLibDescriptors();
        FunctionDescriptor[] fnDesc = null;

        if (tlds == null) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "No tag lib files are specified"));
            return result;
        }

        for (TagLibDescriptor tld : tlds) {
            if (tld.getSpecVersion().compareTo("2.0") >= 0) {
                fnDesc = tld.getFunctionDescriptors();
                if (fnDesc != null)
                    for (FunctionDescriptor fd : fnDesc)
                        checkMethodExistence(result, fd, tld, compName);
            }
        }
        if (result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString(getClass()
                    .getName() +
                    ".passed", "All methods defined in the function-signature element" +
                    "of the tag lib descriptor are properly defined."));
        }
        return result;
    }

    private void checkMethodExistence(Result result, FunctionDescriptor fnDesc,
                                      TagLibDescriptor tld,
                                      ComponentNameConstructor compName) {
        ClassLoader cl = getVerifierContext().getClassLoader();
        String signature = fnDesc.getFunctionSignature();
        String className = fnDesc.getFunctionClass();
        String methodName = getName(signature);
        String retType = getRetType(signature);
        String[] par = getParameters(signature);
        Class [] param = getParamTypeClass(par, cl);
        try {
            Class c = Class.forName(className, false, cl);
            boolean passed = false;
            Method[] methods= c.getMethods();
            for (Method m : methods) {
                if (m.getName().equals(methodName) &&
                        parametersMatch(m, param) &&
                        Modifier.toString(m.getModifiers()).contains("static") &&
                        returnTypeMatch(m, retType)) {
                    passed = true;
                    break;
                }
            }
            if(!passed) {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString(getClass().getName() +
                        ".failed",
                        "Error: The method [ {0} ] as defined in function-signature" +
                        "element of [ {1} ] does not exists or is not a" +
                        "public static method in class [ {2} ]",
                        new Object[]{methodName, tld.getUri(), className }));
            }
        } catch (ClassNotFoundException e) {
            //do nothing. If class is not found, JSP compiler will anyway report
        }
    }
}

