/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;


/**
 * Listener class exists tests.
 * Verify that the Listener class exists inside the .tld file and is loadable.
 * @author Sudipto Ghosh
 */

public class TaglibListenerClassExists extends WebTest implements WebCheck {

    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Context context = getVerifierContext();
        Result result = getInitializedResult();
        TagLibDescriptor tlds[] = context.getTagLibDescriptors();
        ClassLoader cl = context.getClassLoader();

        if (tlds == null) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                            "No tag lib files are specified"));
            return result;
        }

        for (TagLibDescriptor tld:tlds) {
            String[] classes = tld.getListenerClasses();
            if(classes != null) {
                for ( String s : classes ) {
                    Class c = null;
                    try {
                        c = Class.forName(s, false, cl);
                    } catch (ClassNotFoundException e) {
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString
                                (getClass().getName() + ".failed",
                                        "Taglib listener class [ {0} ] found in " +
                                "[ {1} ] is not loadable ",
                                        new Object[] {s, tld.getUri()}));
                    }
                }
            }
        }
        if (result.getStatus()!=Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed1",
                            "taglib listener classes, if any, specified in tlds are loadable"));
        }
        return result;
    }
}
