/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web.elements;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.*;
import java.util.logging.Level;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;


/** 
 * Servlet mime-type element contains a defined mime type.  i.e. "text/plain"
 */
public class MimeTypeElement extends WebTest implements WebCheck, MimeTypes { 

    /**
     * Servlet mime-type element contains a defined mime type.  i.e. "text/plain"
     * 
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor.getMimeMappings().hasMoreElements()) {
	    boolean oneFailed = false;
	    boolean foundIt = false;
	    // get the mimeType's in this .war
	    for (Enumeration e = descriptor.getMimeMappings() ; e.hasMoreElements() ;) {
		foundIt = false;
		MimeMappingDescriptor mimemapping = (MimeMappingDescriptor)e.nextElement();
		String mimeType = mimemapping.getMimeType();
		logger.log(Level.FINE, "servlet mimeType: " + mimeType);
		int pos = mimeType.indexOf("/");
		// user defined
		// see http://www-dos.uniinc.msk.ru/tech1/1995/mime/m_tech.htm#Type

		if (mimeType.substring(pos+1).startsWith("X-") || mimeType.substring(pos+1).startsWith("x-")) {
		    foundIt = true;
		} else if (mimeType.startsWith("X-")) {
                    foundIt = true;
                } else if (mimeType.substring(0,pos).equals("text")) {
		    if (Arrays.asList(text).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		} else if (mimeType.substring(0,pos).equals("multipart")) {
		    if (Arrays.asList(multipart).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		} else if (mimeType.substring(0,pos).equals("message")) {
		    if (Arrays.asList(message).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		} else if (mimeType.substring(0,pos).equals("application")) {
		    if (Arrays.asList(application).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		} else if (mimeType.substring(0,pos).equals("image")) {
		    if (Arrays.asList(image).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		} else if (mimeType.substring(0,pos).equals("audio")) {
		    if (Arrays.asList(audio).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		} else if (mimeType.substring(0,pos).equals("video")) {
		    if (Arrays.asList(video).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		} else if (mimeType.substring(0,pos).equals("model")) {
		    if (Arrays.asList(model).contains(mimeType.substring(pos+1,mimeType.length()))) {
			foundIt = true;
		    } 
		}
   
		if (foundIt) {
		    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "Servlet mime-type [ {0} ] defined for this web application [ {1} ]",
					   new Object[] {mimeType, descriptor.getName()}));
		} else {
		    if (!oneFailed) {
			oneFailed = true;
		    }
		    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.addErrorDetails(smh.getLocalString
					   (getClass().getName() + ".failed",
					    "Error: Servlet mime-type [ {0} ] not defined for this web application [ {1} ]",
					    new Object[] {mimeType, descriptor.getName()}));
		}
	    }
	    if (oneFailed) {
		result.setStatus(Result.FAILED);
	    } else {
		result.setStatus(Result.PASSED);
	    }
	} else {
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no mimemappings within the web archive [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}
	return result;
    }
}
