/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.webservices;

import java.util.List;
import java.util.Iterator;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;

/**
 * @author Sudipto Ghosh
 */
public class HandlerChainClassCheck extends WSTest implements WSCheck {

    public Result check (WebServiceEndpoint descriptor) {

        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        //Handler chains are applicable only in the context of JAX-WS 2.0. So
        // version check for this test is not required.
        List handlerChain = descriptor.getHandlerChain();
        for (Iterator it = handlerChain.iterator(); it.hasNext();) {
            List handlers = ((WebServiceHandlerChain)it.next()).getHandlers();
            for(Iterator itr = handlers.iterator(); itr.hasNext();) {
                String hClass =  ((WebServiceHandler)itr.next()).getHandlerClass();
                try {
                    Class cl = Class.forName(hClass, false, getVerifierContext().getClassLoader());
                    if (!((javax.xml.ws.handler.Handler.class).isAssignableFrom(cl))) {
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString (getClass().getName() + ".failed",
                                "Handler Class [{0}] does not implement " +
                                "javax.xml.ws.handler.Handler Interface",
                                new Object[] {hClass}));
                    }
                } catch (ClassNotFoundException e) {
                    // result.fail, handler class not found
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString (
                            "com.sun.enterprise.tools.verifier.tests.webservices.clfailed",
                            "The [{0}] Class [{1}] could not be Loaded",
                            new Object[] {"Handler Class", hClass}));
                }
            }
        }
        if (result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString (getClass().getName() + ".passed1",
                    "Handler chains, if any, are defined properly"));
        }
        return result;
    }
}
