/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import java.util.*;
import com.sun.enterprise.tools.verifier.tests.*;
import java.lang.reflect.*;

// portnames : verify that all the portnames exist in the WebService
/* 
 *   @class.setup_props: ; 
 */ 

/*  
 *   @testName: check  
 *   @assertion_ids:  JSR109_WS_45; 
 *   @test_Strategy: 
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription: Handler Port Name is a valid portname 
 */
public class HandlerPortNameCheck extends WSTest implements WSCheck {

    /**
     * @param descriptor the WebServices  descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (WebServiceEndpoint descriptor) {

	Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        boolean pass = true;

        if (descriptor.hasHandlers()) {
           Collection allPortNames = getAllPortNamesInService(descriptor);
           List handlerChain = descriptor.getHandlerChain();
           for (Iterator it = handlerChain.iterator(); it.hasNext();) {
               Collection c = ((WebServiceHandler)it.next()).getPortNames();
               Collection invalid = getInvalidHandlerPortNames(c,allPortNames);
               if (invalid.size() > 0) {
                  //result.fail
                  result.addErrorDetails(smh.getLocalString ("tests.componentNameConstructor",
                                   "For [ {0} ]", new Object[] {compName.toString()}));
                 result.failed(smh.getLocalString
                  ("com.sun.enterprise.tools.verifier.tests.webservices.failed",
                   "[{0}]", new Object[] {"The Port Name(s) in the Handler Chain are invalid"}));

                  pass = false;
               }
               else {
                  //result.pass
                  result.addGoodDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
                  result.passed(smh.getLocalString (
                  "com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]",
                  new Object[] {"Port Name(s) in the Handler-Chain are valid"}));

               }
           }
        }
        else {
         // result.NotApplicable
         result.addNaDetails(smh.getLocalString
            ("tests.componentNameConstructor", "For [ {0} ]",
             new Object[] {compName.toString()}));
         result.notApplicable(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.webservices.notapp",
           "[{0}]", new Object[] {"Not Applicable since No handlers defined in this WebService"}));

        }

        return result;
    }

   private Collection getAllPortNamesInService(WebServiceEndpoint descriptor) {

       Collection endPoints = descriptor.getWebService().getEndpoints();
       Vector<String> ret = new Vector<String>();
       for (Iterator it = endPoints.iterator(); it.hasNext();) {
           ret.add(((WebServiceEndpoint)it.next()).getEndpointName());
       }
    return ret;    
   }

   private Collection getInvalidHandlerPortNames(Collection hpNames, Collection allPortNames) {
       
      Vector<String> ret = new Vector<String>();
      for (Iterator it = hpNames.iterator(); it.hasNext();) {
          String currName = (String)it.next();
          if (!allPortNames.contains(currName)) 
              ret.add(currName);
      }
    return ret;
   }
 }

