/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.wsclient;

import javax.enterprise.deploy.shared.ModuleType;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;

/**
 * WebServices harness
 */
public class WebServiceClientCheckMgrImpl extends CheckMgr implements JarCheck {

    /**
     * name of the file containing the list of tests for the webservice client
     * architecture
     */
    private static final String testsListFileName = "TestNamesWebServicesClient.xml"; // NOI18N
    private static final String sunONETestsListFileName = getSunPrefix()
            .concat(testsListFileName);
    private String moduleName;

    public WebServiceClientCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    /**
     * Check Ejb for spec. conformance
     *
     * @param descriptor WebServices descriptor
     */
    public void check(Descriptor descriptor) throws Exception {
        ServiceReferenceDescriptor rootDescriptor = (ServiceReferenceDescriptor) descriptor;
        ModuleType moduleType = rootDescriptor.getBundleDescriptor()
                .getModuleType();
        if (moduleType == ModuleType.EJB)
            moduleName = Result.EJB;
        else if (moduleType == ModuleType.WAR)
            moduleName = Result.WEB;
        else if (moduleType == ModuleType.CAR)
            moduleName = Result.APPCLIENT;
        super.check(rootDescriptor);
    }

    /**
     * return the configuration file name for the list of tests pertinent to the
     * connector architecture
     *
     * @return <code>String</code> filename containing the list of tests
     */
    protected String getTestsListFileName() {
        return testsListFileName;
    }

    /**
     * @return <code>String</code> filename containing sunone tests
     */
    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    /**
     * A webservices client can be an application client or an ejb or a web component
     * For a j2ee1.4 specific webservices client the version of client descriptor
     * is 1.1. For jee 5.0 this version is 1.0
     * @param descriptor
     * @return webservices client descriptor version
     */
    protected String getSchemaVersion(Descriptor descriptor) {
        String wsclientVersion = null;
        String version = ((ServiceReferenceDescriptor) descriptor).getBundleDescriptor()
                .getSpecVersion();
        if(moduleName.equals(Result.EJB)){
            if("2.1".equals(version)) wsclientVersion = "1.1"; // NOI18N
            else if("3.0".equals(version)) wsclientVersion = "1.2"; // NOI18N
        } else if(moduleName.equals(Result.WEB)){
            if("2.4".equals(version)) wsclientVersion = "1.1"; // NOI18N
            else if("2.5".equals(version)) wsclientVersion = "1.2"; // NOI18N
        } else if(moduleName.equals(Result.APPCLIENT)){
            if("1.4".equals(version)) wsclientVersion = "1.1"; // NOI18N
            else if("5".equals(version)) wsclientVersion = "1.2"; // NOI18N
        }
        if(wsclientVersion==null) {
            wsclientVersion = ""; // should we not throw exception?
        }
        return wsclientVersion;
    }

    protected void setModuleName(Result r) {
        r.setModuleName(moduleName);
    }
    
    protected BundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return ((ServiceReferenceDescriptor)descriptor).getBundleDescriptor();
    }
    protected ComponentNameConstructor getComponentNameConstructor(
            Descriptor descriptor) {
        return new ComponentNameConstructor((ServiceReferenceDescriptor)descriptor);
    }

}
