/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ModelVetoException.java
 *
 * Created on August 23, 2000, 10:50 PM
 */

package com.sun.jdo.api.persistence.model;

import java.io.PrintStream;
import java.io.PrintWriter;

import com.sun.jdo.spi.persistence.utility.StringHelper;

/** 
 *
 * @author raccah
 * @version %I%
 */
public class ModelVetoException extends ModelException
{
	/** This field holds the target if the
	 * ModelVetoException (Throwable target) constructor was
	 * used to instantiate the object
	 */
	private Throwable _target;

	/**
	 * Creates new <code>ModelVetoException</code> without detail message and 
	 * <code>null</code> as the target exception.
	 */
	public ModelVetoException ()
	{
	}

	/**
	 * Constructs an <code>ModelVetoException</code> with the specified 
	 * detail message and <code>null</code> as the target exception..
	 * @param msg the detail message.
	 */
	public ModelVetoException (String msg)
	{
		super(msg);
	}

	/**
	 * Constructs a ModelVetoException with a target exception.
	 */
	public ModelVetoException (Throwable target)
	{
		super();
		_target = target;
	}

	/**
	 * Constructs a ModelVetoException with a target exception
	 * and a detail message.
	 */
	public ModelVetoException (Throwable target, String s)
	{
		super(s);
		_target = target;
	}

	/**
	 * Get the thrown target exception.
	 */
	public Throwable getTargetException() { return _target; }

	/**
	* Returns the error message string of this throwable object.
	* @return the error message string of this <code>ModelVetoException</code>
	* object if it was created with an error message string, the error 
	* message of the target exception if it was not created a message 
	* but the target exception has a message, or <code>null</code> if 
	* neither has an error message.
	*
	*/
	public String getMessage()
	{
		String message = super.getMessage();

		if (StringHelper.isEmpty(message))
		{
			Throwable target = getTargetException();

			message	= target.getMessage();
		}

		return message;
	}

	/**
	 * Prints the stack trace of the thrown target exception.
	 * @see java.lang.System#err
	 */
	public void printStackTrace ()
	{
		printStackTrace(System.err);
	}

	/**
	 * Prints the stack trace of the thrown target exception to the specified
	 * print stream.
	 */
	public void printStackTrace (PrintStream ps)
	{
		synchronized (ps)
		{
			Throwable target = getTargetException();

			if (target != null)
			{
				ps.print(getClass() + ": ");			// NOI18N
				target.printStackTrace(ps);
			}
			else
				super.printStackTrace(ps);
		}
	}

	/**
	 * Prints the stack trace of the thrown target exception to the
	 * specified print writer.
	 */
	public void printStackTrace (PrintWriter pw)
	{
		synchronized (pw)
		{
			Throwable target = getTargetException();

			if (target != null)
			{
				pw.print(getClass() + ": ");			// NOI18N
				target.printStackTrace(pw);
			}
			else
				super.printStackTrace(pw);
		}
	}
}
