/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PersistenceWrapper.java
 *
 * Create on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore;


// This is a thin wrapper for Persistent class

public class PersistenceWrapper {
    public static final int IN_USE = 1;
    public static final int NOT_IN_USE = 2;
    public static final int DELETED = 3;

    // flags that indicate if all Persistent objects
    // in use for this primary key object, how many copies
    // of the instance exist (inUse > 0), and if any one of
    // them has been deleted (state == DELETED)
    private int state = 0;
    private int inUse = 0;

    // Persistent object itself
    private Object persistent = null;

    public void setState(int newstate) {
        this.state = newstate;
    }

    public int getState() {
        return state;
    }

    public void addInUse() {
        inUse++;
    }

    public int removeInUse() {
        if (inUse > 0) {
            inUse--;
        }
        return inUse;
    }

    public int getInUse() {
        return inUse;
    }

    public void setPersistent(Object newobject) {
        persistent = newobject;
    }

    public Object getPersistent() {
        return persistent;
    }

}
