/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.support.sqlstore;

/**
 * A cache of "version consistent" StateManager instances.  These instances
 * are used so that we can avoid loading state from the database.
 *
 * @author Dave Bristor
 */
public interface VersionConsistencyCache {
    /**
     * Puts the given StateManager into a map that is keyed by the given OID.
     * We anticipate that implementations will want to use a two-level map,
     * and so the pc's class can be used as a key into a map to access a
     * second map, which would be that keyed by OID.
     * @param pcType class of instance, used as key in outer map.
     * @param oid Object id, used as key in inner map.
     * @param sm StateManager bound to <code>oid</code> in inner map.
     */
    public StateManager put(Class pcType, Object oid, StateManager sm);

    /**
     * Returns an SM, if found, else null.
     * @param pcType class of instance, used as key in outer map.
     * @param oid Object id, used as key in inner map.
     */
    public StateManager get(Class pcType, Object oid);

    /**
     * Removes entry based on pc and oid.  If map is empty after remove,
     * removes it from its containint map.
     * @param pcType class of instance, used as key in outer map.
     * @param oid Object id, used as key in inner map.
     */
    public StateManager remove(Class pcType, Object oid);

    /**
     * Informs the cache to expect that the given pcType will be used as a key
     * for the outer map in subsequent <code>putEntry</code> operations.
     * @param pcType class of instance, used as key in outer map.
     */
    public void addPCType(Class pcType);

    /**
     * Removes the map for the given pcType and all its elements.
     * @param pcType class of instance, used as key in outer map.
     */
    public void removePCType(Class pcType);
}
