/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Nesting.java
 *
 * Created on March 8, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This class is used to handle the hidden definition
 * of an identifier. If an identifier is declared its old 
 * definition is hidden and stored in the actual nesting.
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public class Nesting
{
    /**
     * List of idents with hidden definitions in the actual scope.
     */
    protected List idents;
    
    /**
     * List of hidden definitions; each definition in this list
     * corresponds to an identifier of the list idents.
     */
    protected List hiddenDefs;

    /**
     * Creates an new nesting.
     */
    public Nesting()
    {
        this.idents = new ArrayList();
        this.hiddenDefs = new ArrayList();
    }

    /**
     * Adds a hidden definition to this.
     * @param ident name of the identifier
     * @param hidden the hidden definition of ident
     */
    public void add(String ident, Definition hidden)
    {
        idents.add(ident);
        hiddenDefs.add(hidden);
    }

    /**
     * Returns an enumeration of idents with hidden definitions.
     */
    public Iterator getIdents()
    {
        return idents.iterator();
    }

    /**
     * Returns an enumeration of hidden definitions.
     */
    public Iterator getHiddenDefinitions()
    {
        return hiddenDefs.iterator();
    }
}
