/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MappingContext.java
 *
 * Created on January 28, 2002, 6:30 PM
 */

package com.sun.jdo.spi.persistence.utility;

import java.util.*;

/** Special resource bundle which delegates to two others.
 * Ideally could just set the parent on the first, but this is protected, 
 * so it might not work.  It's still unclear whether that approach would work 
 * in this subclass because it may break the localization fall through 
 * mechanism if used.
 * Note: This code is copied from NbBundle in the openide sources with 
 * the following modifications:
 * - reformatting
 * - making variables final
 * - renaming variables and some params
 * - removing locale code
 * - creating the merged set of keys using jdk classes and not nb utils
 *
 * @author Rochelle Raccah
 * @version %I%
 */
public class MergedBundle extends ResourceBundle
{
	private final ResourceBundle _mainBundle, _parentBundle;

	public MergedBundle (ResourceBundle mainBundle, 
		ResourceBundle parentBundle)
	{
		_mainBundle = mainBundle;
		_parentBundle = parentBundle;
	}

	public Enumeration getKeys () { return mergeKeys(); }

	private Enumeration mergeKeys ()
	{
		Set noDuplicatesMerge = 
			new HashSet(getCollection(_mainBundle.getKeys()));

		noDuplicatesMerge.addAll(getCollection(_parentBundle.getKeys()));

		return Collections.enumeration(noDuplicatesMerge);
	}

	private Collection getCollection (Enumeration enumeration)
	{
		List returnList = new ArrayList();

		if (enumeration != null)
		{
			while (enumeration.hasMoreElements())
				returnList.add(enumeration.nextElement());
		}

		return returnList;
	}

	protected Object handleGetObject (String key)
		throws MissingResourceException
	{
		try
		{
			return _mainBundle.getObject(key);
		}
		catch (MissingResourceException mre)	// try the other bundle
		{
			return _parentBundle.getObject(key);
		}
	}
}
