/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.exceptions.i18n;

import java.util.ListResourceBundle;

/**
 * INTERNAL:
 * English ResourceBundle for TransactionException messages.
 *
 */
public class TransactionExceptionResource extends ListResourceBundle {
    static final Object[][] contents = {
                                           { "23001", "Error looking up external Transaction resource under JNDI name [{0}]" },
                                           { "23002", "Error obtaining status of current externally managed transaction" },
                                           { "23003", "Error obtaining current externally managed transaction" },
                                           { "23004", "Error obtaining the Transaction Manager" },
                                           { "23005", "Error binding to externally managed transaction" },
                                           { "23006", "Error beginning new externally managed transaction" },
                                           { "23007", "Error committing externally managed transaction" },
                                           { "23008", "Error rolling back externally managed transaction" },
                                           { "23009", "Error marking externally managed transaction for rollback" },
                                           { "23010", "No externally managed transaction is currently active for this thread" },
                                           { "23011", "UnitOfWork [{0}] was rendered inactive before associated externally managed transaction was complete" },
                                           { "23012", "No transaction is currently active" },
                                           { "23013", "Transaction is currently active" },
                                           { "23014", "Cannot use an EntityTransaction while using JTA." },
                                           { "23015", "Cannot enlist multiple datasources in the transaction." },
                                           { "23016", "Exception in Proxy execution." }
    };

    /**
     * Return the lookup table.
     */
    protected Object[][] getContents() {
        return contents;
    }
}
