/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.util.HashSet;

import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQuery;
import javax.persistence.PrimaryKeyJoinColumns;

import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.helper.DatabaseField;

/**
 * INTERNAL:
 * This class is a wrapper to an actual TopLink Descriptor. It is also 
 * responsible for storing other data that we want to keep around during 
 * the annotation processing.
 * 
 * @author Guy Pelletier
 * @since TopLink 10.1.3/EJB 3.0 Preview
 */
public class AnnotationsDescriptor extends MetadataDescriptor {
    private HashSet<NamedQuery> m_namedQueries;
    private HashSet<NamedNativeQuery> m_namedNativeQueries;
    
    /**
     * INTERNAL: 
     */
    public AnnotationsDescriptor(Class javaClass) {
        super(javaClass);
        init();
    }
    
    /**
     * INTERNAL:
     * Constructor used for wrapping an existing descriptor which was
     * presumably loaded from the project xml.
     */
    public AnnotationsDescriptor(ClassDescriptor descriptor, Class javaClass) {
        super(descriptor, javaClass);
        init();
    }
    
    /**
     * INTERNAL:
     * Copy constructor. Used for creation of annotations meta data out of xml 
     * meta data.
     */
    public AnnotationsDescriptor(MetadataDescriptor md) {
        super(md);
        m_mappedSuperclasses = null; // Force the re-calculation of mapped superclasses.
        init();
    }
    
    /**
     * INTERNAL:
     */
    public void addNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        m_namedNativeQueries.add(namedNativeQuery);
    }
    
    /**
     * INTERNAL:
     */
    public void addNamedQuery(NamedQuery namedQuery) {
        m_namedQueries.add(namedQuery);
    }
    
	/**
     * INTERNAL:
     */
    public HashSet<NamedNativeQuery> getNamedNativeQueries() {
        return m_namedNativeQueries;
    }
    
    /**
     * INTERNAL:
     */
    public HashSet<NamedQuery> getNamedQueries() {
        return m_namedQueries;
    }
    
    /**
     * INTERNAL:
     * Satisfy the abstract method declaration in MetadataDescriptor
     */
    public void handlePotentialDefaultTableUsage(DatabaseField dbField) {
        // do nothing ..
    }
    
    /**
     * INTERNAL:
     */
    protected boolean hasEntityTag(Class cls) {
        return cls.isAnnotationPresent(Entity.class);
    }
    
    /**
     * INTERNAL:
     */
    protected boolean hasInheritanceTag(Class entityClass) {
        return entityClass.isAnnotationPresent(Inheritance.class);
    }
    
    /**
     * INTERNAL:
	 * Return true if the given class is tagged as a mapped-superclass.
     */
	protected boolean hasMappedSuperclassTag(Class cls) {
        return cls.isAnnotationPresent(MappedSuperclass.class);
    }
    
    /**
     * INTERNAL:
	 * Method to check if the class has a @JoinColumns.
     */
	public boolean hasPrimaryKeyJoinColumns() {
		return m_javaClass.isAnnotationPresent(PrimaryKeyJoinColumns.class);
    }
    
    /**
     * INTERNAL:
     */
    private void init() {
        m_namedQueries = new HashSet<NamedQuery>();
        m_namedNativeQueries = new HashSet<NamedNativeQuery>();
    }
    
	/**
     * INTERNAL:
     * Stored on the root class of an inheritance hierarchy.
     */
    public void setInheritanceStrategy(InheritanceType inheritanceStrategy) {
        if (inheritanceStrategy == InheritanceType.TABLE_PER_CLASS) {
            throw ValidationException.tablePerClassInheritanceNotSupported(m_javaClass);
        }
        
    	m_usesSingleTableInheritanceStrategy = (inheritanceStrategy == InheritanceType.SINGLE_TABLE);
    }

    /**
     * INTERNAL:
     * Returns true if a class uses property access. In an inheritance 
     * hierarchy, the subclasses inherit their access type from the parent.
     * The metadata helper method caches the class access types for 
     * efficiency.
     */
	public boolean usesPropertyAccess() {
        if (isInheritanceSubclass()) {
            return AnnotationsHelper.usesPropertyAccess((AnnotationsDescriptor) getInheritanceRootDmd());
        } else {
            return AnnotationsHelper.usesPropertyAccess(this);
        }
    }
}
