/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.exceptions.ValidationException;

/**
 * Validator class for the metadata processors. It defines the common 
 * validation exceptions used by the metadata processors.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public abstract class MetadataValidator  {    
    /**
     * INTERNAL
     */
    public void throwCouldNotFindMapKey(String fieldOrPropertyName, Class referenceClass, DatabaseMapping mapping) {
        throw ValidationException.couldNotFindMapKey(fieldOrPropertyName, referenceClass, mapping);
    }
    
    /**
     * INTERNAL
     */
    abstract public void throwEmbeddedIdAndIdFound(Class entityClass, String attributeName, String idAttributeName);
    
    /**
     * INTERNAL
     */
    abstract public void throwExcessiveJoinColumnsSpecified(Class entityClass, Object element);
    
    /**
     * INTERNAL
     */
    abstract public void throwExcessivePrimaryKeyJoinColumnsSpecified(Object Element);
    
    /**
     * INTERNAL
     */
    abstract public void throwIncompleteJoinColumnsSpecified(Class entityClass, Object element);
    
    /**
     * INTERNAL
     */
    abstract public void throwIncompletePrimaryKeyJoinColumnsSpecified(Class entityClass);
    
    /**
     * INTERNAL
     */
    public void throwInvalidCompositePKSpecification(Class entityClass, String idClassName) {
        throw ValidationException.invalidCompositePKSpecification(entityClass, idClassName);    
    }
    
    /**
     * INTERNAL
     */
    public void throwInvalidEmbeddableAttribute(Class entityClass, String attributeName, Class embeddedClass, String embeddedAttributeName) {
        throw ValidationException.invalidEmbeddableAttribute(embeddedClass, embeddedAttributeName, entityClass, attributeName);
    }    
    
    /**
     * INTERNAL
     */
    public void throwInvalidOrderByValue(Class entityClass, String propertyOrFieldName, Class referenceClass, String attributeName) {
        throw ValidationException.invalidOrderByValue(propertyOrFieldName, referenceClass, attributeName, entityClass);
    }    
        
    /**
     * INTERNAL
     */
    public void throwInvalidTypeForEnumeratedAttribute(Class entityClass, String attributeName, Class referenceClass) {
        throw ValidationException.invalidTypeForEnumeratedAttribute(attributeName, referenceClass, entityClass);
    }  
    
    /**
     * INTERNAL
     */
    public void throwInvalidTypeForLOBAttribute(Class entityClass, String attributeName, Class referenceClass) {
        throw ValidationException.invalidTypeForLOBAttribute(attributeName, referenceClass, entityClass);
    }  
    
    /**
     * INTERNAL
     */
    public void throwInvalidTypeForSerializedAttribute(Class entityClass, String attributeName, Class referenceClass) {
        ValidationException.invalidTypeForSerializedAttribute(attributeName, referenceClass, entityClass);   
    }  
    
    /**
     * INTERNAL
     */
    public void throwInvalidTypeForTemporalAttribute(Class entityClass, String attributeName, Class referenceClass) {
        throw ValidationException.invalidTypeForTemporalAttribute(attributeName, referenceClass, entityClass);
    }  
    
    /**
     * INTERNAL
     */  
    public void throwNonUniqueEntityName(String clsName1, String clsName2, String name) {
        throw ValidationException.nonUniqueEntityName(clsName1, clsName2, name);
    }

    /**
     * INTERNAL
     */
    abstract public void throwMultipleEmbeddedIdsFound(Class entityClass, String attributeName, String embeddedIdAttributeName);
    
    /**
     * INTERNAL
     */
    abstract public void throwNoMappedByAttributeFound(Class owningClass, String owningAttributeName, Class entityClass, String attributeName);
    
    /**
     * INTERNAL
     */
    abstract public void throwNoTemporalTypeSpecified(Class entityClass, String attributeName);
    
    /**
     * INTERNAL
     */
    abstract public void throwRelationshipHasColumnSpecified(Class entityClass, String attributeName);
    
    /**
     * INTERNAL
     */
    abstract public void throwUniDirectionalOneToManyHasJoinColumnSpecified(Class entityClass, String attributeName);
}
