/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import oracle.toplink.essentials.logging.SessionLog;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;

/**
 * Logger class for the EntityMappingsXMLProcessor and the XMLSequencingProcessor.
 */
public class EntityMappingsXMLLogger extends MetadataLogger  {
    // ORM specific messages.    
    public static final String IGNORE_SECONDARY_TABLE = "orm_warning_ignore_secondary_table";
    public static final String IGNORE_MAPPING_ON_WRITE = "orm_warning_ignore_mapping_on_write";
    public static final String IGNORE_QUERY_HINT_UNKNOWN_TYPE = "orm_warning_ignore_query_hint_unknown_type";
    public static final String IGNORE_QUERY_HINT_UNSUPPORTED_TYPE = "orm_warning_ignore_query_hint_unsupported_type";
    
    /**
     * INTERNAL:
     */
    public EntityMappingsXMLLogger(AbstractSession session) {
        super(session);
    }
    
    /**
     * INTERNAL:
     * Init the shared context strings.
     */
    protected void initSharedContextStrings() {
        IGNORE_TABLE = "orm_warning_ignore_table";
        IGNORE_QUERY = "orm_warning_ignore_query";
    	IGNORE_MAPPING = "orm_warning_ignore_mapping";
        IGNORE_ID_CLASS = "orm_warning_ignore_id_class";
        IGNORE_PRIMARY_KEY = "orm_warning_ignore_primary_key";
        IGNORE_EMBEDDED_ID = "orm_warning_ignore_embedded_id";
        IGNORE_INHERITANCE = "orm_warning_ignore_inheritance";
        IGNORE_VERSION_LOCKING = "orm_warning_ignore_version_locking";
    }
    
    /**
     * INTERNAL:
     * Logging utility method.
     */
    public void log(int level, String ctx, Object[] params) {
        session.log(level, SessionLog.EJB_ORM, getLoggingContextString(ctx), params);
    }
    
    /**
     * INTERNAL:
	 * Populate context strings.
     */
	protected void populateContextStrings() {   
        super.populateContextStrings();
        
        ctxStrings.put(IGNORE_SECONDARY_TABLE, IGNORE_SECONDARY_TABLE);
        ctxStrings.put(IGNORE_MAPPING_ON_WRITE, IGNORE_MAPPING_ON_WRITE);
        ctxStrings.put(IGNORE_QUERY_HINT_UNSUPPORTED_TYPE, IGNORE_QUERY_HINT_UNSUPPORTED_TYPE);
        ctxStrings.put(IGNORE_QUERY_HINT_UNKNOWN_TYPE, IGNORE_QUERY_HINT_UNKNOWN_TYPE);
	}
}
