/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml;
import java.util.ArrayList;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

public class TableInfo {
    String tableName;
    String catalog;
    String schema;
    ArrayList uniqueConstraints;
    boolean specified;

    public TableInfo() {
        this.tableName = "";
        this.catalog = "";
        this.schema = "";
        this.uniqueConstraints = new ArrayList();
        this.specified = true;
    }
    
    public TableInfo(String tableName, String catalog, String schema, ArrayList uniqueConstraints) {
        this.tableName = tableName;
        this.catalog = catalog;
        this.schema = schema;
        this.uniqueConstraints = uniqueConstraints;
        specified = true;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
    
    public String getFullyQualifiedTableName() {
        return MetadataHelper.getFullyQualifiedTableName(tableName, catalog, schema);
    }
    
    public String getCatalog() {
        return catalog;
    }
    
    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }
    
    public String getSchema() {
        return schema;
    }
    
    public void setSchema(String schema) {
        this.schema = schema;
    }
    
    public ArrayList getUniqueConstraints() {
        return uniqueConstraints;
    }

    public void setUniqueConstraints(ArrayList uniqueConstraints) {
        this.uniqueConstraints = uniqueConstraints;
    }
    
    public void isSpecified(boolean isSpecified) {
        this.specified = isSpecified;
    }
    
    public boolean specified() {
        return specified;
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof TableInfo) {
            TableInfo table = (TableInfo) objectToCompare;

            if (!table.getTableName().equals(this.getTableName())) {
                return false;
            }
            if (!table.getCatalog().equals(this.getCatalog())) {
                return false;
            }
            if (!table.getSchema().equals(this.getSchema())) {
                return false;
            }
            if (table.getUniqueConstraints().equals(this.getUniqueConstraints())) {
                return false;
            }
            if (table.specified() != this.specified()) {
                return false;
            }
            return true;
        }
        return false;
    }
}
