/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

/**
 * INTERNAL:
 * Static values for XML processing.
 */
public class XMLConstants {
    // miscellaneous values
    public static final String FIELD = "field";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String ORM_SCHEMA_NAME = "orm_1_0.xsd";
    public static final String PERSISTENCE_SCHEMA_NAME = "persistence_1_0.xsd";
    public static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String VALIDATING = "http://xml.org/sax/features/validation";
    public static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String ALL = "ALL";
    static final String ALL_CHILDREN = "child::*";
    static final String CALLBACK_METHODS = "CALLBACK_METHODS";
    static final String DEFAULT_PKFIELD_NAME = "TOPLINKDEFAULTID";
    static final String DEFAULT_TEMPORAL = "TIMESTAMP";
    static final String EAGER = "EAGER";
    static final String ENTITIES_TO_DEFAULT = "entitiesToDefault";
    static final String ENTITIES_TO_PROCESS = "entitiesToProcess";
    static final String LAZY = "LAZY";
    static final String ORDINAL = "ORDINAL";
    static final String PROPERTY = "PROPERTY";
    static final String SET = "set";
    static final String SINGLE_TABLE = "SINGLE_TABLE";
    static final String TABLE_PER_CLASS = "TABLE_PER_CLASS";
    static final String TEXT = "text()";
    
    // attribute values
    static final String ATT_ACCESS = "@access";
    static final String ATT_ALLOCATION_SIZE = "@allocation-size";
    static final String ATT_CATALOG = "@catalog";
    static final String ATT_CLASS = "@class";
    static final String ATT_COLUMN = "@column";
    static final String ATT_COLUMN_DEFINITION = "@column-definition";
    static final String ATT_DISCRIMINATOR_COLUMN = "@discriminator-column";
    static final String ATT_DISCRIMINATOR_TYPE = "@discriminator-type";
    static final String ATT_ENTITY_CLASS = "@entity-class";
    static final String ATT_FETCH = "@fetch";
    static final String ATT_GENERATOR = "@generator";
    static final String ATT_INITIAL_VALUE = "@initial-value";
    static final String ATT_INSERTABLE = "@insertable";
    static final String ATT_LENGTH = "@length";
    static final String ATT_MAPPED_BY = "@mapped-by";
    static final String ATT_METADATA_COMPLETE = "@metadata-complete";
    static final String ATT_METHOD_NAME = "@method-name";
    static final String ATT_NAME = "@name";
    static final String ATT_NULLABLE = "@nullable";
    static final String ATT_OPTIONAL = "@optional";
    static final String ATT_PK_COLUMN_NAME = "@pk-column-name";
    static final String ATT_PK_COLUMN_VALUE = "@pk-column-value";
    static final String ATT_PRECISION = "@precision";
    static final String ATT_REFERENCED_COLUMN_NAME = "@referenced-column-name";
    static final String ATT_RESULT_CLASS = "@result-class";
    static final String ATT_RESULT_SET_MAPPING = "@result-set-mapping";
    static final String ATT_SCALE = "@scale";
    static final String ATT_SCHEMA = "@schema";
    static final String ATT_SECONDARY_TABLE = "@secondary-table";
    static final String ATT_TABLE = "@table";
    static final String ATT_SEQUENCE_NAME = "@sequence-name";
    static final String ATT_STRATEGY = "@strategy";
    static final String ATT_TARGET_ENTITY = "@target-entity";
    static final String ATT_UNIQUE = "@unique";
    static final String ATT_UPDATABLE = "@updatable";
    static final String ATT_VALUE = "@value";
    static final String ATT_VALUE_COLUMN_NAME = "@value-column-name";
    static final String ATT_VERSION = "@version";

    // element/complex-type values
    static final String ACCESS = "access";
    static final String ATTRIBUTES = "attributes";
    static final String ASSOCIATION_OVERRIDE = "association-override";
    static final String ATTRIBUTE_OVERRIDE = "attribute-override";
    static final String BASIC = "basic";
    static final String CASCADE = "cascade";
    static final String CASCADE_PERSIST = "cascade-persist";
    static final String CATALOG = "catalog";
    static final String COLUMN = "column";
    static final String COLUMN_NAME = "column-name";
    static final String COLUMN_RESULT = "column-result";
    static final String DEFAULT_ENTITY_LISTENERS = "default-entity-listeners";
    static final String DESCRIPTION = "description";
    static final String DISCRIMINATOR_COLUMN = "discriminator-column";
    static final String DISCRIMINATOR_VALUE = "discriminator-value";
    static final String EMBEDDED = "embedded";
    static final String EMBEDDED_ID = "embedded-id";
    static final String EMBEDDABLE = "embeddable";
    static final String EMBEDDABLE_ATTRIBUTE = "embeddable-attribute";
    static final String ENTITY = "entity";
    static final String ENTITY_LISTENER = "entity-listener";
    static final String ENTITY_LISTENERS = "entity-listeners";
    static final String ENTITY_MAPPINGS = "entity-mappings";
    static final String ENTITY_RESULT = "entity-result";
    static final String ENUMERATED = "enumerated";
    static final String EXCLUDE_DEFAULT_LISTENERS = "exclude-default-listeners";
    static final String EXCLUDE_SUPERCLASS_LISTENERS = "exclude-superclass-listeners";
    static final String FIELD_RESULT = "field-result";
    static final String FLUSH_MODE = "flush-mode";
    static final String GENERATED_VALUE = "generated-value";
    static final String ID = "id";
    static final String ID_CLASS = "id-class";
    static final String INHERITANCE = "inheritance";
    static final String INVERSE_JOIN_COLUMN = "inverse-join-column";
    static final String JOIN_COLUMN = "join-column";
    static final String JOIN_TABLE = "join-table";
    static final String LOB = "lob";
    static final String MANY_TO_MANY = "many-to-many";
    static final String MANY_TO_ONE = "many-to-one";
    static final String MAPKEY = "map-key";
    static final String MAPPED_SUPERCLASS = "mapped-superclass";
    static final String METADATA_COMPLETE = "xml-mapping-metadata-complete";
    static final String NAMED_NATIVE_QUERY = "named-native-query";
    static final String NAMED_QUERY = "named-query";
    static final String ONE_TO_MANY = "one-to-many";
    static final String ONE_TO_ONE = "one-to-one";
    static final String ORDER_BY = "order-by";
    static final String PACKAGE = "package";
    static final String PK_JOIN_COLUMN = "primary-key-join-column";
    static final String POST_LOAD = "post-load";
    static final String POST_PERSIST = "post-persist";
    static final String POST_REMOVE = "post-remove";
    static final String POST_UPDATE = "post-update";
    static final String PRE_PERSIST = "pre-persist";
    static final String PRE_REMOVE = "pre-remove";
    static final String PRE_UPDATE = "pre-update";
    static final String PU_DEFAULTS = "persistence-unit-defaults";
    static final String PU_METADATA = "persistence-unit-metadata";
    static final String QUERY = "query";
    static final String QUERY_HINT = "hint";
    static final String SCHEMA = "schema";
    static final String SECONDARY_TABLE = "secondary-table";
    static final String SEQUENCE_GENERATOR = "sequence-generator";
    static final String SQL_RESULT_SET_MAPPING = "sql-result-set-mapping";
    static final String TABLE = "table";
    static final String TABLE_GENERATOR = "table-generator";
    static final String TEMPORAL = "temporal";
    static final String TRANSIENT = "transient";
    static final String UNIQUE_CONSTRAINTS = "unique-constraint";
    static final String VERSION = "version";
}
