/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;

/**
 * INTERNAL:
 * This class is a wrapper to an actual TopLink Descriptor. It is also 
 * responsible for storing other data that we want to keep around during 
 * XML processing.
 * 
 * @author Dave McCann, Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLDescriptorMetadata extends MetadataDescriptor {
    private XMLHelper m_helper;
	private boolean m_usesPropertyAccess; 
    
    /**
     * INTERNAL: 
     */
    public XMLDescriptorMetadata(Class javaClass, XMLHelper xmlHelper) {
        super(javaClass);
        m_helper = xmlHelper;
        m_usesPropertyAccess = false;
    }
    
    /**
     * INTERNAL:
     * Constructor used for wrapping an existing descriptor which was presumably 
     * loaded from the project xml.
     * 
     * NOTE:  This constructor assumes that no methods that require 
     * m_helper will be called, and hence should not be called if
     * any document processing is required.
     */
    public XMLDescriptorMetadata(ClassDescriptor descriptor, Class javaClass) {
        super(descriptor, javaClass);
        m_helper = null;
        m_usesPropertyAccess = false;
    }

    /**
     * INTERNAL:
     * Constructor used for wrapping an existing descriptor which was
     * presumably loaded from the project xml.
     */
    public XMLDescriptorMetadata(ClassDescriptor descriptor, Class javaClass, XMLHelper xmlHelper) {
        super(descriptor, javaClass);
        m_helper = xmlHelper;
        m_usesPropertyAccess = false;
    }
    
    /**
     * INTERNAL:
     */
    public void handleComplexDefaultPrimaryKeyUsage(DatabaseField dbField) {
        if (isDefaultPrimaryKeySet()) {
        	getFieldsWithComplexDefaultPrimaryKeySet().add(dbField);
        }
    }
    
    /**
     * INTERNAL:
     */
    public void handleDefaultPrimaryKeyUsage(DatabaseField dbField) {
        if (isDefaultPrimaryKeySet()) {
        	getFieldsWithDefaultPrimaryKeySet().add(dbField);
        }
    }
    
    /**
     * INTERNAL:
     */
    public void handlePotentialDefaultTableUsage(DatabaseField dbField) {
        if (isDefaultPrimaryTableSet() && dbField.getTableName().equals(getPrimaryTableName())) {
        	getFieldsWithDefaultPrimaryTableSet().add(dbField);
        }
    }
    
    /**
     * INTERNAL:
     */
    protected boolean hasEntityTag(Class cls) {
        return m_helper.locateNodeForEntity(cls) != null;
    }
    
    /**
     * INTERNAL:
     */
    protected boolean hasInheritanceTag(Class entityClass) {
        return m_helper.nodeHasInheritance(m_helper.locateNodeForEntity(entityClass));
    }
    
    /**
     * INTERNAL:
	 * Return true if the given class is tagged as a mapped-superclass.
     */
	protected boolean hasMappedSuperclassTag(Class cls) {
        return m_helper.locateNodeForMappedSuperclass(cls) != null;
    }
    
    /**
     * INTERNAL:
	 * Method to check if the class has a primary-key-join-column sub-element.
     */
	public boolean hasPrimaryKeyJoinColumns() {
        return m_helper.nodeHasPrimaryKeyJoinColumns(m_helper.locateNodeForEntity(m_javaClass));
    }
     
    /**
     * INTERNAL:
     */
    public void setHelper(XMLHelper helper) {
        m_helper = helper;
    }
    
    /**
     * INTERNAL: 
     * Set to true if accessor methods should be created on the mappings.
     */
     public void setUsesPropertyAccess(boolean usesPropertyAccess) {
         m_usesPropertyAccess = usesPropertyAccess;
     }
     
    /**
     * INTERNAL:
     * Returns true if accessor methods should be created for the mappings.
     */
	public boolean usesPropertyAccess() {
        return m_usesPropertyAccess;
    }
}
