package oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing;

public class SequenceGenerator {
    private String name;
    private String sequenceName;
    private int initialValue;
    private int allocationSize;
    
    public SequenceGenerator(String name, String sequenceName, int initialValue, int allocationSize) {
        this.name = name;
        this.sequenceName = sequenceName;
        this.initialValue = initialValue;
        this.allocationSize = allocationSize;
    }
    
    public String name() {
        return name;
    }
    
    public String sequenceName() {
        return sequenceName;
    }
    
    public int initialValue() {
        return initialValue;
    }
    
    public int allocationSize() {
        return allocationSize;
    }
    
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof SequenceGenerator) {
            SequenceGenerator generator = (SequenceGenerator) objectToCompare;
            
            if (!generator.name().equals(this.name())) { 
                return false;
            }
            if (!generator.sequenceName().equals(this.sequenceName())) {
                return false;
            }
            if (generator.initialValue() != this.initialValue()) {
                return false;
            }
            if (generator.allocationSize() != this.allocationSize()) {
                return false;
            }
            return true;
        }
        return false;
    }
}
