/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.*;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Represent a BETWEEN in EJBQL
 * <p><b>Responsibilities</b>:<ul>
 * <li> Generate the correct expression for a BETWEEN in EJBQL
 * </ul>
 *    @author Jon Driscoll and Joel Lucuik
 *    @since TopLink 4.0
 */
public class BetweenNode extends SimpleConditionalExpressionNode {
    protected Node rightForBetween;
    protected Node rightForAnd;

    /**
     * BetweenNode constructor comment.
     */
    public BetweenNode() {
        super();
    }

    /**
     * INTERNAL
     * Validate node and calcualte its type.
     */
    public void validate(ParseTreeContext context) {
        Object type = null;
        if (left != null) {
            left.validate(context);
            type = left.getType();
        }
        if (rightForBetween != null) {
            rightForBetween.validate(context);
            rightForBetween.validateParameter(context, type);
        }
        if (rightForAnd != null) {
            rightForAnd.validate(context);
            rightForAnd.validateParameter(context, type);
        }
        TypeHelper typeHelper = context.getTypeHelper();
        setType(typeHelper.getBooleanType());
    }

    /**
     * INTERNAL
     * Return a TopLink expression by 'BETWEEN' and 'AND'ing the expressions from the left,
     * rightForBetween and rightForAnd nodes
     */
    public Expression generateExpression(GenerationContext context) {
        // Get the left expression
        Expression whereClause = getLeft().generateExpression(context);

        // Between it with whatever the rightForBetween expression and rightForAnd expressions are
        whereClause = whereClause.between(getRightForBetween().generateExpression(context), getRightForAnd().generateExpression(context));

        // and return the expression...
        return whereClause;
    }

    public Node getRightForAnd() {
        return rightForAnd;
    }

    public Node getRightForBetween() {
        return rightForBetween;
    }

    public boolean hasRightForAnd() {
        return rightForAnd != null;
    }

    public boolean hasRightForBetween() {
        return rightForBetween != null;
    }

    public void setRightForAnd(Node newRightForAnd) {
        rightForAnd = newRightForAnd;
    }

    public void setRightForBetween(Node newRightForBetween) {
        rightForBetween = newRightForBetween;
    }
}
