/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.*;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Represent a LOCATE
 * <p><b>Responsibilities</b>:<ul>
 * <li> Generate the correct expression for a LOCATE
 * </ul>
 *    @author Jon Driscoll and Joel Lucuik
 *    @since TopLink 4.0
 */
public class LocateNode extends ArithmeticFunctionNode {
    private Node find = null;
    private Node findIn = null;
    private Node startPosition = null;
    private boolean handleStartPosition = false;

    /**
     * Return a new LocateNode.
     */
    public LocateNode() {
        super();
    }

    /**
     * INTERNAL
     * Validate node and calculate its type.
     */
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (findIn != null) {
            findIn.validate(context);
            findIn.validateParameter(context, typeHelper.getStringType());
        }
        if (find != null) {
            find.validate(context);
            find.validateParameter(context, typeHelper.getStringType());
        }
        if (startPosition != null) {
            startPosition.validate(context);
            startPosition.validateParameter(context, typeHelper.getIntType());
        }
        setType(typeHelper.getIntType());
    }

    /**
     * INTERNAL
     * Generate the TopLink expression for this node
     */
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = getFindIn().generateExpression(context);
        Expression findExpr = getFind().generateExpression(context);
        if (handleStartPosition) {
            whereClause = whereClause.locate(findExpr, getStartPosition().generateExpression(context));
        } else {
            whereClause = whereClause.locate(findExpr);
        }
        return whereClause;
    }

    // Accessors
    public Node getFind() {
        return find;
    }

    public Node getFindIn() {
        return findIn;
    }

    public void setFind(Node newFind) {
        find = newFind;
    }

    public void setFindIn(Node newFindIn) {
        findIn = newFindIn;
    }

    public void handleStartPosition() {
        handleStartPosition = true;
    }

    public Node getStartPosition() {
        return startPosition;
    }
    
    public void setStartPosition(Node newStartPosition) {
        startPosition = newStartPosition;
    }
    
}
