/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.tools.schemaframework;

import java.io.*;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class TimesTenSequenceDefinition extends OracleSequenceDefinition {

    public TimesTenSequenceDefinition(String name, int preallocationSize) {
        super(name, preallocationSize);
    }
    
    public TimesTenSequenceDefinition(String name, int preallocationSize, int start) {
        super(name, preallocationSize, start);
    }    
    
    public TimesTenSequenceDefinition(String name) {
        super(name);
    }
    
    /**
     * INTERNAL:
     * Return the SQL required to create the Oracle sequence object.
     */
    public Writer buildCreationWriter(AbstractSession session, Writer writer) {
        try {
            writer.write("CREATE SEQUENCE ");
            writer.write(getFullName());
            if (getIncrement() != 1) {
                writer.write(" INCREMENT BY " + getIncrement());
            }
            if (getStart() != 1) {
                writer.write(" MINVALUE " + getStart());
            }
        } catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    /**
     * INTERNAL:
     * Indicates whether alterIncrement is supported
     */
    public boolean isAlterSupported() {
        return false;
    }

}