/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Sorter.java
 *
 * Created on January 18, 2001, 3:53 PM
 */

package com.sun.enterprise.tools.common;

/**
 *
 * @author  administrator
 * @version 
 */
// public class Sorter extends java.lang.Object {

import java.util.*;

public class Sorter
{	
	
	////////////////////////////////////////////////////////////////////////////////
	
	public static void sort(Vector v) 
	{
		if(v.size() <= 1)
			return;

		SorterObject[] arr = new SorterObject[v.size()];
		Enumeration e = v.elements();
		
		for(int i = 0 ; e.hasMoreElements() ; i++)
		{
			arr[i] = new SorterObject(e.nextElement());
		}

		mergeSort(arr);

		v.removeAllElements();

		for(int i = 0; i < arr.length; i++)
		{
			v.addElement(arr[i].obj);
		}
	}
	
	////////////////////////////////////////////////////////////////////////////////

	private static void mergeSort(SorterObject[] arr)
	{
		int low = 0;
		int high = arr.length;

		for (int i = low; i < high; i++)
		{
			for (int j = i; j > low &&	arr[j-1].sortName.compareTo(arr[j].sortName) > 0; j--)
			{
				swap(arr, j, j-1);
			}
		}
	}
	
	////////////////////////////////////////////////////////////////////////////////

	private static void swap(SorterObject x[], int a, int b) 
	{
		SorterObject t = x[a];
		x[a] = x[b];
		x[b] = t;
	}
	
	////////////////////////////////////////////////////////////////////////////////

	private static void print(Vector v, String s)
	{
		System.out.println(s + "\n");//NOI18N

		for(Enumeration e = v.elements(); e.hasMoreElements(); )
		{
			System.out.println("" + e.nextElement());//NOI18N
		}
	}
	
	////////////////////////////////////////////////////////////////////////////////

	public static void main(String[] args)
	{
		Vector v1 = new Vector();
		//Vector v2 = new Vector();
		//Vector v3 = new Vector();

		v1.addElement("aaaa");//NOI18N
		v1.addElement("zzzz");//NOI18N
		v1.addElement("dddd");//NOI18N
		v1.addElement("ccccx");//NOI18N
		v1.addElement("cccc");//NOI18N
		v1.addElement("cccc");//NOI18N
		v1.addElement("cccc");//NOI18N
		v1.addElement("bbbb");//NOI18N

		print(v1, "****** before");//NOI18N
		sort(v1);
		print(v1, "\n******after");//NOI18N
	}
	
	////////////////////////////////////////////////////////////////////////////////
}

////////////////////////////////////////////////////////////////////////////////

class SorterObject
{
	SorterObject(Object obj)
	{
		this.obj = obj;
		sortName = obj.toString();
	}
	String sortName;
	Object obj;
}
