/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PrincipalsRenderer.java
 *
 * Created on March 19, 2002, 11:56 AM
 */

package com.sun.enterprise.tools.common.properties;

import javax.swing.*;
import java.util.*;
import java.text.*;

/**
 *
 * @author  shirleyc
 * @version 
 */
public class PrincipalsRenderer extends JLabel implements javax.swing.table.TableCellRenderer {
    
    private static java.util.ResourceBundle bundle =
        java.util.ResourceBundle.getBundle("com.sun.enterprise.tools.common.properties.Bundle"); //NOI18N
    
    public PrincipalsRenderer() {
    }

    public java.awt.Component getTableCellRendererComponent(javax.swing.JTable jTable, java.lang.Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            setText(MessageFormat.format(bundle.getString("PLURAL_PRIN_CAPTION"), new Object[] {"0"}));  //NOI18N
        }
        else if (value instanceof Vector) {
            if (((Vector)value).size() == 1)
                setText(bundle.getString("SINGLE_PRIN_CAPTION"));   //NOI18N
            else
                setText(MessageFormat.format(bundle.getString("PLURAL_PRIN_CAPTION"), new Object[] {new Integer(((Vector)value).size())}));   //NOI18N
        }
        else 
            System.out.println(value);            
        return this;
    }
}
