/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Commands.java
 *
 * Created on June 7, 2004, 2:41 PM
 */

package com.sun.enterprise.tools.upgrade.common;

import java.io.*;
import com.sun.enterprise.cli.framework.CLIMain;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.util.i18n.StringManager;

/**
 *
 * @author  hans
 */
public class Commands {
    private static StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.common");
    
    /** Creates a new instance of Commands */
    public Commands() {
    }
    
    public static boolean deploy(String modulePath, CommonInfoModel commonInfo) {
        String currentDomain = commonInfo.getCurrentDomain();
        String adminPort = DomainsProcessor.getTargetDomainPort(currentDomain, commonInfo);
        String adminSecurity = DomainsProcessor.getTargetDomainSecurity(currentDomain, commonInfo);
        String edition = commonInfo.getTargetEdition();
        String [] deploy = {
                "deploy", "--user", commonInfo.getAdminUserName(),
                //"--password", commonInfo.getAdminPassword(),
                "--passwordfile ", "\"" + commonInfo.getPasswordFile()+ "\"",
                "--port",adminPort, 
                "--secure=" + adminSecurity, 
                "\"" + modulePath + "\""
            };
        if(!commonInfo.getTargetEdition().equals(UpgradeConstants.EDITION_PE)){            
            String targetName = commonInfo.getCurrentCluster();
            if(targetName == null){
                targetName = commonInfo.getCurrentSourceInstance();
            }
            if((targetName != null) && (!("".equals(targetName)))){
                deploy = new String[]{
                    "deploy", "--user", commonInfo.getAdminUserName(),
                    //"--password", commonInfo.getAdminPassword(),
                    "--passwordfile ", "\"" + commonInfo.getPasswordFile()+ "\"",
                    "--port",adminPort, 
                    "--secure=" + adminSecurity, 
                    "--target", targetName,
                    "\"" + modulePath + "\""
                };
            }
        }
        try {
            return executeCommand(deploy);
        } catch (CommandException ce) {
            Throwable t = ce.getCause();
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.generalExceptionMsg") + " " + (t==null?ce.getMessage():t.getMessage()));
        }
        CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.errorDeployingMsg") + modulePath);
        return false;
    }
    
    public static boolean startDomain(String domainName, CommonInfoModel commonInfo) {
        String command[] = {
            //"start-domain", "--user", commonInfo.getAdminUserName(), "--password", commonInfo.getAdminPassword(), "--passwordfile ", "\"" + commonInfo.getPasswordFile() +"\"", domainName
            "start-domain", "--domaindir", "\"" + commonInfo.getTargetDomainRoot() +"\"", "--user", commonInfo.getAdminUserName(), "--passwordfile ", "\"" + commonInfo.getPasswordFile() +"\"", domainName
        };
        
        try {
            boolean b = executeCommand(command);
            return b;
        } catch (CommandException ce) {
            Throwable t = ce.getCause();
            CommonInfoModel.getDefaultLogger().severe(stringManager.getString("commands.generalExceptionMsg") + ce.getMessage());
            if (t != null) {
                String message = t.getMessage();
                if(message != null){
                    CommonInfoModel.getDefaultLogger().severe(stringManager.getString("commands.generalExceptionMsg") + message);
                    if ( message.indexOf(stringManager.getString("commands.DomainRunningFragment")) != -1 || 
                        (stringManager.getString("commands.DomainRunningFragment").equalsIgnoreCase("No local string defined") && 
                        message.indexOf("running") != -1 )) {
                        CommonInfoModel.getDefaultLogger().severe(stringManager.getString("commands.DomainRunningMsg", domainName));   
                    }
                }
            }
        }
        return false;
    }
    
    public static boolean stopDomain(String domainName, CommonInfoModel commonInfo) {
        String command[] = {
            "stop-domain", "--domaindir", "\"" + commonInfo.getTargetDomainRoot() +"\"", domainName
        };
        try {
            boolean b = executeCommand(command);
            return b;
        } catch (CommandException ce) {
            Throwable t = ce.getCause();
            if (t != null && t.getMessage().indexOf("is not running") != -1) {
                return true;
            }
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.generalExceptionMsg") + ce.getMessage());
        }
        return false;
    }
    
    public static boolean executeCommand(String commandStrings[]) throws CommandException {
        try {
            StringBuffer commandOneString = new StringBuffer();
            for(int i = 0; i < commandStrings.length; i++) {
                commandOneString.append(commandStrings[i]).append(" ");
            }
            InputsAndOutputs io = InputsAndOutputs.getInstance();
            PipedOutputStream pos = new PipedOutputStream();
            io.setErrorOutput(pos);
            io.setUserOutput(pos);
            CommandOutputReader cor = new CommandOutputReader(pos);
            ((Thread)cor).start();
            CommonInfoModel.getDefaultLogger().info(stringManager.getString("commands.executingCommandMsg") + commandOneString);
            CLIMain.invokeCLI(commandOneString.toString(), io);
            pos.flush();
            return true;
        }
        catch(CommandException ce) {
            throw ce;
        }
        catch(Exception e) {
            Throwable t = e.getCause();
            CommonInfoModel.getDefaultLogger().warning(stringManager.getString("commands.generalExceptionMsg") + (t==null?e.getMessage():t.getMessage()));
        }
        return false;
    }
    
    
    static class CommandOutputReader extends Thread {
        PipedInputStream pis = new PipedInputStream();
        public CommandOutputReader(PipedOutputStream pout) throws IOException {
            pis.connect(pout);
        }
        
        public void run() {
            //Start CR 6376140
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(pis));
            //DataInputStream dis = new DataInputStream(pis);
            //end CR 6376140
            try {
                //Start CR 6376140
                String s = null;
                while((s=buffReader.readLine()) != null) {
                //while ( dis.available() > -1 ) {
                    CommonInfoModel.getDefaultLogger().info(s);
                }
                //end CR 6376140
                pis.close();
            } catch (IOException ioe) {
                try {
                    //start CR 6376140
                    buffReader.close();
                    //dis.close();
                    //end CR 6376140
                    pis.close();
                } catch (Exception e) {
                    CommonInfoModel.getDefaultLogger().info(e.getMessage());
                }
            }
        }
    }
}
