/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.upgrade.common.arguments;

import java.io.File;

/**
 *
 * @author Hans Hrasna 
 */
public class ARG_target extends ArgumentHandler {
    
    /** Creates a new instance of ARG_target */
    public ARG_target(ParsedArgument pa) {
        super(pa);
        if(parameters.isEmpty()){
            helpUsage(sm.getString("enterprise.tools.upgrade.cli.argument_missing","--target/-t"));
            System.exit(1);
        }
        String targetDir = (String)parameters.firstElement();
        if(!utils.isValidTargetPath(targetDir)){
            helpUsage();
            _logger.severe(sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
            System.exit(1);
        }
        //For backward compatibility if the target is the same as the install directory
        //we use the setting of AS_DEF_DOMAINS_PATH as before for the domains root
        if(!new File(targetDir).equals(new File(commonInfo.getTargetInstallDir()))) {
            commonInfo.setTargetDomainRoot(targetDir);
        }
        commonInfo.enlistDomainsFromSource();
    }
    
}
