/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.gui;

import java.awt.*;


public class HeaderPanel extends InsetsPanel
{

    private String headerText;
    private Header header;
    private int preferredHeight;

    public HeaderPanel()
    {
        this("", 55);
    }

    public HeaderPanel(String s)
    {
        this(s, 55);
    }

    public HeaderPanel(String s, int i)
    {
        headerText = null;
        header = null;
        headerText = s;
        preferredHeight = i;
        setLayout(new BorderLayout());
        add(header = new Header(s), "North");        
    }

    public Dimension getMinimumSize()
    {
        return getPreferredSize();
    }

    public Dimension getPreferredSize()
    {
        Dimension dimension = new Dimension(getSize().width, preferredHeight);
        return dimension;
    }

    public String getText()
    {
        if(header != null)
        {
            return header.getText();
        } else
        {
            return headerText;
        }
    }

    public void setText(String s)
    {
        headerText = s;
        if(header != null)
        {
            header.setText(s);
        }
    }
}
