
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/util/stringifier/ArrayStringifier.java,v 1.3 2005/12/25 03:46:01 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:46:01 $
 */
 
package com.sun.cli.util.stringifier;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;

/*
	Stringifies an array, using an optional array element Stringifier
 */
 
public final class ArrayStringifier implements Stringifier
{
	public final String			mDelim;
	public final Stringifier	mElementStringifier;
	
		public 
	ArrayStringifier(  )
	{
		this( SmartStringifier.DEFAULT );
	}
	
		public
	ArrayStringifier( String delim )
	{
		this( delim, SmartStringifier.DEFAULT );
	}
	
		public
	ArrayStringifier( Stringifier elementStringifier )
	{
		this( ",", elementStringifier );
	}
	
		public
	ArrayStringifier( String delim, Stringifier elementStringifier )
	{
		mDelim				= delim;
		mElementStringifier	= elementStringifier;
	}
	
		public String
	stringify( Object o )
	{
		return( this.stringify( (Object [])o, mDelim, mElementStringifier ) );
	}
	
	/*
		Static variant when direct call will suffice.
	 */
		public static String
	stringify( Object [] o, String delim, Stringifier stringifier )
	{
		final Iterator	iter	= Arrays.asList( o ).iterator();
		
		final IteratorStringifier	s	= new IteratorStringifier( delim, stringifier );
		
		return( s.stringify( iter ) );
	}
	/*
		Static variant when direct call will suffice.
	 */
		public static String
	stringify( Object [] o, String delim )
	{
		return( stringify( o, delim, SmartStringifier.DEFAULT ) );
	}
	
	public final static ArrayStringifier DEFAULT = new ArrayStringifier( "," );
}

