/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.base.Util;
import javax.management.MalformedObjectNameException;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ResourceConfig;
import com.sun.appserv.management.base.XTypes;
import java.lang.NullPointerException;
import javax.management.RuntimeOperationsException;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.Iterator;
import java.util.Vector;
import java.lang.IllegalArgumentException;
import java.io.File;
import java.io.IOException;



/**
 *  @version  $Revision: 1.3 $
 */
public class AMXListResourcesCommand extends S1ASCommand
{
    public final static String DOMAIN_CONFIG_OBJECT_NAME = "amx:j2eeType=X-DomainConfig,name=na";
    public final static String SERVER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-StandaloneServerConfig,name=";
    public final static String CLUSTER_CONFIG_OBJECT_NAME = "amx:j2eeType=X-ClusterConfig,name=";
    public final static String TARGET_NAME = "target";

    /**
     *  An abstract method that validates the options 
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of 
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException
    {
    	return super.validateOptions();
    }
   
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() throws CommandException, CommandValidationException
    {
        if (!validateOptions())
            throw new CommandValidationException("Validation is false");


        //use http connector
        MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                                              getUser(), getPassword());
        final Vector vTargetName = getOperands();
        final String targetName = (vTargetName.size()>0)?(String)vTargetName.get(0):null;
        
            //if targetName is not null, then try to get the Config ObjectName of the
            //target.
        ObjectName targetON = (targetName!=null && !targetName.equals(DOMAIN))?
                              getTargetConfigObjectName(mbsc, targetName):null;
        
        final Object[] params = getParamsInfo();
        final String operationName = getOperationName();
        final String[] types = getTypesInfo();
        final String j2eeType = (String) ((Vector) getProperty(PARAMS)).get(0);

        try {
            Object resources = mbsc.invoke(Util.newObjectName(DOMAIN_CONFIG_OBJECT_NAME),
                                           operationName,
                                           params, types);

            Map candidates = (Map)resources;

            if (targetON != null ) {
                candidates = getResourcesFromTarget(mbsc, targetON, candidates);
            }
            displayMap("", (Map)candidates);
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                                                       "CommandSuccessful",
                                                       new Object[] {name}));
        }
        catch (Exception e) {
            displayExceptionMessage(e);
        }
        

    }


        /**
         * Given the Server/Cluster ObjectName, get all the referenced resources.
         * Then loop through the given  resources in the DomainConfig to
         * determine the referenced resources in the ObjectName.
         * @param mbsc
         * @param targetON
         * @return Map of the referenced resources
         */
    private Map getResourcesFromTarget(MBeanServerConnection mbsc,
                                      ObjectName targetON,
                                      Map candidates)
        throws Exception
    {
        Object resourceRefs = mbsc.invoke(targetON,
                                          "getContaineeObjectNameMap",
                                          new Object[]{new String(XTypes.RESOURCE_REF_CONFIG)},
                                          new String[]{"java.lang.String"});

        final Set resourceKeySet = ((Map)resourceRefs).keySet();
        final Iterator resourceKeyIter = resourceKeySet.iterator();
        Map resMap = new HashMap();
        while (resourceKeyIter.hasNext()) {
            final String valueName = (String)resourceKeyIter.next();
            CLILogger.getInstance().printDebugMessage("Candidate = " + valueName );
            if (candidates.containsKey(valueName)) {
                resMap.put(valueName, candidates.get(valueName));
            }
        }
        return resMap;
    }
    

        /**
         * This routine will display the exception message if the option
         * --terse is given.  This routine will get the root of the exception
         * and display the message.  It will then wrap it with CommaneException
         * and throw the exception to be handled by CLI framework.
         * @param e
         * @throws CommandException
         */
    public void displayExceptionMessage(Exception e) throws CommandException
    {
            //get the root cause of the exception
        Throwable rootException = ExceptionUtil.getRootCause(e);
        
        if (rootException.getLocalizedMessage() != null)
            CLILogger.getInstance().printDetailMessage(rootException.getLocalizedMessage());
        throw new CommandException(getLocalizedString("CommandUnSuccessful",
                                                      new Object[] {name} ), e);

    }


        /**
         *  This routine will get the StandaloneServerConfig or ClusterConfig
         *  by the given target name.
         *  @param MBeanServerConnection
         *  @param targetName
         *  @return ObjectName
         */
    private ObjectName getTargetConfigObjectName(final MBeanServerConnection mbsc,
                                                 final String targetName)
        throws CommandException
    {
        try {
            ObjectName scON = Util.newObjectName(SERVER_CONFIG_OBJECT_NAME+targetName);
            if (!mbsc.isRegistered(scON))
                scON = Util.newObjectName(CLUSTER_CONFIG_OBJECT_NAME+targetName);
            if (!mbsc.isRegistered(scON))
                throw new CommandException(getLocalizedString("InvalidTargetName"));
        
            return scON;            
        }
        catch (RuntimeOperationsException roe)
        {
            throw new CommandException(roe);
        }
        catch (IOException ioe)
        {
            throw new CommandException(ioe);
        }
    }

        
    /**
        Display a Map to System.out.
     */
    private void displayMap(final String msg, final Map m)
    {
        final Set keySet = m.keySet();
        if (keySet.isEmpty()) {
            CLILogger.getInstance().printDetailMessage(
                getLocalizedString("NoElementsToList"));
            return;
        }
        final Iterator keyIter = keySet.iterator();
        
        while (keyIter.hasNext()) {
            final String valueName = (String)keyIter.next();
            CLILogger.getInstance().printMessage(msg + " " + valueName );
        }
    }

}
