/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;


/**
 *  This is an abstract class to be inherited by
 *  StartDatabaseCommand and StopDatabaseCommand.
 *  This classes prepares the variables that is used to
 *  to invoke DerbyControl.  It also contains a pingDatabase
 *  method that is used by both start/stop database command.
 *  @author <a href="mailto:jane.young@sun.com">Jane Young</a> 
 *  @version  $Revision: 1.2 $
 */
public abstract class DatabaseCommand extends S1ASCommand
{
    private final static String DB_HOST       = "dbhost";
    private final static String DB_PORT       = "dbport";
    
    protected String dbHost;
    protected String dbPort;
    protected String dbLocation;
    protected String sJavaHome;
    protected String sInstallRoot;
    protected String sClasspath;
    protected String sDatabaseClasspath;

    /**
     * Prepare variables to invoke start/ping database command
     * DatabaseCommand.
     */
    protected void prepareProcessExecutor() throws Exception
    {
        dbHost = getOption(DB_HOST);
        dbPort = getOption(DB_PORT);
	checkIfPortIsValid(dbPort);
        dbLocation = System.getProperty(SystemPropertyConstants.DERBY_ROOT_PROPERTY);
        sJavaHome = System.getProperty(SystemPropertyConstants.JAVA_ROOT_PROPERTY);
        sInstallRoot = System.getProperty(SystemPropertyConstants.INSTALL_ROOT_PROPERTY);
	//	sClasspath = System.getProperty("java.class.path");
	sClasspath = sInstallRoot+File.separator+"lib"+File.separator+
                     "appserv-rt.jar"+File.pathSeparator+sInstallRoot+
	             File.separator+"lib"+File.separator+"admin-cli.jar";
        sDatabaseClasspath = dbLocation+File.separator+"lib"+
                                       File.separator+"derby.jar"+
                                       File.pathSeparator+dbLocation+
                                       File.separator+"lib"+File.separator+
                                       "derbytools.jar"+File.pathSeparator+
                                       dbLocation+File.separator+"lib"+
                                       File.separator+"derbynet.jar"+
                                       File.pathSeparator+dbLocation+File.separator+
                                       "lib"+File.separator+"derbyclient.jar";
    }


  /** check if database port is valid.
   *  Derby does not check this so need to add code to check the port number.
   */
    private void checkIfPortIsValid(final String port) throws CommandValidationException
    {
        try
        {
            Integer.parseInt(port);
        }
        catch(Exception e)
        {
            throw new CommandValidationException(getLocalizedString("InvalidPortNumber", new Object[] {port}));
        }
    }
    


    /**
       defines the command to ping the derby database
       Note that when using Darwin (Mac), the property,
       "-Dderby.storage.fileSyncTransactionLog=True" is defined.
    */
    protected String[] pingDatabaseCmd(boolean bRedirect) throws Exception
    {
        if (OS.isDarwin()) {
            return new String [] {
                    sJavaHome+File.separator+"bin"+File.separator+"java",
                    "-Djava.library.path="+sInstallRoot+File.separator+"lib",
                    "-Dderby.storage.fileSyncTransactionLog=True",
                    "-cp",
                    sClasspath + File.pathSeparator + sDatabaseClasspath,
                    "com.sun.enterprise.cli.commands.DerbyControl",
                    "ping", dbHost, dbPort, new Boolean(bRedirect).toString()
            };
        }
        else {
            return new String [] {
                sJavaHome+File.separator+"bin"+File.separator+"java",
                "-Djava.library.path="+sInstallRoot+File.separator+"lib",
                "-cp",
                sClasspath + File.pathSeparator + sDatabaseClasspath,
                "com.sun.enterprise.cli.commands.DerbyControl",
                "ping", dbHost, dbPort, new Boolean(bRedirect).toString()
            };
        }
    }
}
