/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.server.Constants;
import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.admin.common.constant.DeploymentConstants;


// jdk imports
import java.io.File;
import java.util.Iterator;
import java.util.Properties;


/**
 *  This is the GetClientStubs command
 */
public class GetClientStubsCommand extends S1ASCommand
{
    private String downloadDir;
    private String appName;
    public static final String APP_NAME = "appname";

    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() 
            throws CommandException, CommandValidationException
    {
        validateOptions();

	//use http connector
	final MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), 
								    getPort(), 
								    getUser(), 
								    getPassword());

        String path = getClientStub(mbsc);

	// getClientStub(mbsc,retrievePath, type);

        CLILogger.getInstance().printDetailMessage(getLocalizedString(
        				     "CommandSuccessful",
	 				     new Object[] {name} ) );
    }


    /**
     *  An abstract method that validates the options 
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of 
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException
    {
        super.validateOptions();
        downloadDir = (String) getOperands().get(0);
	validateDirectory();
        appName = getAppName();
	return true;
    }


    /** 
     *  check if file path exist on the local file system
     *  @throws CommandValidationExcetion if file not found
     */
    private void validateDirectory() throws CommandValidationException
    {
        File dlDir = new File(downloadDir);
	if (!dlDir.exists() )
        {
            dlDir.mkdirs();
        }
        if(!dlDir.exists() || !dlDir.canWrite() || !dlDir.isDirectory() ) {
            throw new CommandValidationException(getLocalizedString(
						 "InvalidDirectory",new Object [] {downloadDir}));
        }
    }
    
    private String getAppName() throws CommandValidationException
    {
        String name = getOption(APP_NAME);
        return name;
    }



	
    /**
     *  retrieve client stub from server
     */
    private String getClientStub(MBeanServerConnection mbsc)
	throws CommandException
    {
	try 
	{

	    final String fileName = new JMXFileTransfer(mbsc).downloadClientStubs(
							 appName, 
							 downloadDir);
	    CLILogger.getInstance().printDebugMessage("Downloaded client stubs to: " + fileName);
        return fileName;
	}
	catch (Exception e)
	{
            Throwable t = e.getCause();
            while(t!=null && t.getCause()!=null)
                t=t.getCause();
            if(t==null)
                t=e;
	    throw new CommandException(t.getLocalizedMessage(),t);
	}
    }


}
