/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.IOException;


/**
	This class represents the user is in interactive mode.
	This class provides the users response.
 */
public class UserInput implements IUserInput
{

    private InputStream mInputStr;
    private boolean mInteractive;
    private BufferedReader buffRead;


    /**
       Constructor which sets the InputStream and the interactive mode.
       @param      in is an InputStream object representation of users
                   response.
    */
    public UserInput(InputStream in)
    {
	mInputStr      =    in;
	mInteractive   =    true;
	buffRead = new BufferedReader(new InputStreamReader(mInputStr));
    }


    /**
       Returns a boolean which tells the program is in interactive mode.
    */
    public boolean isInteractive()
    {
	return mInteractive;
    }


    /**
       Closes the underlying input stream.
    */
    public void	close() throws IOException
    {
	mInputStr.close();
    }

    /**
     *  Set the character encoding
     *  @param sEncoding - character encoding to set
     */
    public void setEncoding(String sEncoding) throws IOException
    {
//	buffRead.close();
	InputStreamReader inStrReader = new InputStreamReader(
	              			    mInputStr, sEncoding);
	buffRead = new BufferedReader(inStrReader);
//	inStrReader.close();
    }


    /**
       Returns a String representation of users response.
       Could be next line in the stream provided.
    */
    public String getLine() throws IOException
    {
	//InputStreamReader inStrReader = new InputStreamReader(mInputStr);
	//BufferedReader buffRead = new BufferedReader(inStrReader);
        return buffRead.readLine();
    }

    /**
     *  Returns a Character representation of users response.
     */
    public int getChar() throws IOException
    {
	return buffRead.read();
    }

}

