/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.*;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.4 $
 */

public class OutputTest extends TestCase {
    public void testNotClosedWhenDone() throws Exception {
        final TestStream ts = new TestStream();
        final Output out = new Output(ts, false);
        out.close();
        assertTrue("Expected test stream to still be open", !ts.isClosed());
    }
        
    public void testClosedWhenDone() throws Exception {
        final TestStream ts = new TestStream();
        final Output out = new Output(ts, true);
        out.close();
        assertTrue("Expected test stream to be closed", ts.isClosed());
    }
    
    public void testPrintlnObject() throws Exception {
        final ByteArrayOutputStream bout = new ByteArrayOutputStream();
        final Output out = new Output(bout, true);
        final Object o = new Object();
        out.println(o);
        out.flush();
        assertEquals(o.toString() + System.getProperty("line.separator"), bout.toString());
    }
        
    public void testPrintln() throws Exception {
        final ByteArrayOutputStream bout = new ByteArrayOutputStream();
        final Output out = new Output(bout, true);
        out.println("m");
        out.flush();
        assertEquals("m" + System.getProperty("line.separator"), bout.toString());
    }
        
    public void testPrintObject() throws Exception {
        final ByteArrayOutputStream bout = new ByteArrayOutputStream();
        final Output out = new Output(bout, true);
        final Object o = new Object();
        out.print(o);
        out.flush();
        //need to add "\n" at the end since bout.toString() returns a newline at the end
        assertEquals(o.toString()+"\n", bout.toString());
    }
        
    public void testSimpleUse() throws Exception {
        final ByteArrayOutputStream bout = new ByteArrayOutputStream();
        final Output out = new Output(bout, true);
        out.print("m");
        out.flush();
        assertEquals("m", bout.toString());
    }

    public OutputTest(String name){
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void nyi(){
        fail("Not Yet Implemented");
    }

    public static void main(String args[]){
        if (args.length == 0){
            junit.textui.TestRunner.run(OutputTest.class);
        } else {
            junit.textui.TestRunner.run(makeSuite(args));
        }
    }
    private static TestSuite makeSuite(String args[]){
        final TestSuite ts = new TestSuite();
        for (int i = 0; i < args.length; i++){
            ts.addTest(new OutputTest(args[i]));
        }
        return ts;
    }
}

class TestStream extends ByteArrayOutputStream 
{
    private boolean closed = false;
    public void close() throws IOException {
        super.close();
        closed = true;
    }
    boolean isClosed() {
        return closed;
    }
}
