/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/base/SystemInfo.java,v 1.3 2005/12/25 03:49:01 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:49:01 $
 */

package com.sun.appserv.management.base;


/**
	Provides information about the capabilities of the running server.
	Callers should check only for specific capabilities, never whether
	the server is PE/SE/EE, since the feature assortment could vary with
	release.
 */
public interface SystemInfo extends AMX
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.SYSTEM_INFO;
	
	/**
		Call supportsFeature() with this value to determine if the server
		supports clusters.
	 */
	public final String	CLUSTERS_FEATURE	= "SupportsClusters";
	
	/**
		Call supportsFeature() with this value to determine if the server
		supports more than one server.
	 */
	public final String	MULTIPLE_SERVERS_FEATURE	= "SupportsMultipleServers";
	
	
	/**
		Call supportsFeature() with this value to determine if this MBean
		is running in the Domain Admin Server.
	 */
	public final String	RUNNING_IN_DAS_FEATURE		= "RunningInDomainAdminServer";
	
	
	
	/**
		Query whether a feature is supported.  Features require the use
		of a key, which may be any of:
		<ul>
		<li>CLUSTERS_FEATURE</li>
		<li>MULTIPLE_SERVERS_FEATURE</li>
		<li>RUNNING_IN_DAS_FEATURE</li>
		</ul>
		
		@param key	the feature to query
	 */
	public boolean	supportsFeature( String key );
	
	/**
		Return all features names.
		
		@return Set
	 */
	public String[]		getFeatureNames();
	



}
